/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.datasource.pool;

import io.ebean.datasource.PoolStatus;
import io.ebean.datasource.pool.BusyConnectionBuffer;
import io.ebean.datasource.pool.ConnectionPool;
import io.ebean.datasource.pool.FreeConnectionBuffer;
import io.ebean.datasource.pool.Log;
import io.ebean.datasource.pool.PooledConnection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

final class PooledConnectionQueue {
    private static final TimeUnit MILLIS_TIME_UNIT = TimeUnit.MILLISECONDS;
    private final String name;
    private final ConnectionPool pool;
    private final FreeConnectionBuffer freeList;
    private final BusyConnectionBuffer busyList;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private int connectionId;
    private final long waitTimeoutMillis;
    private final long maxAgeMillis;
    private final int minSize;
    private int maxSize;
    private int waitingThreads;
    private int waitCount;
    private int hitCount;
    private long totalAcquireNanos;
    private long maxAcquireNanos;
    private int highWaterMark;
    private long lastResetTime;
    private boolean doingShutdown;
    private final long validateStaleMillis;

    PooledConnectionQueue(ConnectionPool pool) {
        this.pool = pool;
        this.name = pool.name();
        this.minSize = pool.minSize();
        this.maxSize = pool.maxSize();
        this.waitTimeoutMillis = pool.waitTimeoutMillis();
        this.maxAgeMillis = pool.maxAgeMillis();
        this.validateStaleMillis = pool.validateStaleMillis();
        this.busyList = new BusyConnectionBuffer(this.maxSize, 20);
        this.freeList = new FreeConnectionBuffer();
        this.lock = new ReentrantLock(false);
        this.notEmpty = this.lock.newCondition();
    }

    private PoolStatus createStatus() {
        return new ConnectionPool.Status(this.minSize, this.maxSize, this.freeList.size(), this.busyList.size(), this.waitingThreads, this.highWaterMark, this.waitCount, this.hitCount, this.totalAcquireNanos, this.maxAcquireNanos);
    }

    public String toString() {
        this.lock.lock();
        try {
            String string = this.createStatus().toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PoolStatus status(boolean reset) {
        this.lock.lock();
        try {
            PoolStatus s = this.createStatus();
            if (reset) {
                this.highWaterMark = this.busyList.size();
                this.hitCount = 0;
                this.waitCount = 0;
                this.maxAcquireNanos = 0L;
                this.totalAcquireNanos = 0L;
            }
            PoolStatus poolStatus = s;
            return poolStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    void setMaxSize(int maxSize) {
        this.lock.lock();
        try {
            if (maxSize < this.minSize) {
                throw new IllegalArgumentException("maxSize " + maxSize + " < minSize " + this.minSize);
            }
            this.busyList.setCapacity(maxSize);
            this.maxSize = maxSize;
        }
        finally {
            this.lock.unlock();
        }
    }

    private int totalConnections() {
        return this.freeList.size() + this.busyList.size();
    }

    void ensureMinimumConnections() throws SQLException {
        this.lock.lock();
        try {
            int add = this.minSize - this.totalConnections();
            if (add > 0) {
                for (int i = 0; i < add; ++i) {
                    this.freeList.add(this.pool.createConnectionForQueue(this.connectionId++));
                }
                this.notEmpty.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void returnPooledConnection(PooledConnection c, boolean forceClose) {
        this.lock.lock();
        try {
            if (!this.busyList.remove(c)) {
                Log.error("Connection [{0}] not found in BusyList?", c);
            }
            if (forceClose || c.shouldTrimOnReturn(this.lastResetTime, this.maxAgeMillis)) {
                c.closeConnectionFully(false);
            } else {
                this.freeList.add(c);
                this.notEmpty.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private PooledConnection extractFromFreeList() {
        if (this.freeList.isEmpty()) {
            return null;
        }
        PooledConnection c = this.freeList.remove();
        if (this.validateStaleMillis > 0L && this.staleEviction(c)) {
            c.closeConnectionFully(false);
            return null;
        }
        this.registerBusyConnection(c);
        return c;
    }

    private boolean staleEviction(PooledConnection c) {
        if (!this.stale(c)) {
            return false;
        }
        if (Log.isLoggable(System.Logger.Level.DEBUG)) {
            Log.debug("stale connection validation millis:{0}", System.currentTimeMillis() - c.lastUsedTime());
        }
        return this.pool.invalidConnection(c);
    }

    private boolean stale(PooledConnection c) {
        return c.lastUsedTime() < System.currentTimeMillis() - this.validateStaleMillis;
    }

    PooledConnection obtainConnection() throws SQLException {
        try {
            PooledConnection pc = this._obtainConnection();
            pc.resetForUse();
            return pc;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException("Interrupted getting connection from pool", e);
        }
    }

    private int registerBusyConnection(PooledConnection connection) {
        int busySize = this.busyList.add(connection);
        if (busySize > this.highWaterMark) {
            this.highWaterMark = busySize;
        }
        return busySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledConnection _obtainConnection() throws InterruptedException, SQLException {
        long start = System.nanoTime();
        this.lock.lockInterruptibly();
        try {
            if (this.doingShutdown) {
                throw new SQLException("Trying to access the Connection Pool when it is shutting down");
            }
            ++this.hitCount;
            if (this.waitingThreads == 0) {
                PooledConnection freeConnection = this.extractFromFreeList();
                if (freeConnection != null) {
                    PooledConnection pooledConnection = freeConnection;
                    return pooledConnection;
                }
                if (this.busyList.size() < this.maxSize) {
                    PooledConnection c = this.pool.createConnectionForQueue(this.connectionId++);
                    int busySize = this.registerBusyConnection(c);
                    if (Log.isLoggable(System.Logger.Level.DEBUG)) {
                        Log.debug("DataSource [{0}] grow; id[{1}] busy[{2}] max[{3}]", this.name, c.name(), busySize, this.maxSize);
                    }
                    PooledConnection pooledConnection = c;
                    return pooledConnection;
                }
            }
            try {
                ++this.waitCount;
                ++this.waitingThreads;
                PooledConnection pooledConnection = this._obtainConnectionWaitLoop();
                --this.waitingThreads;
                return pooledConnection;
            }
            catch (Throwable throwable) {
                --this.waitingThreads;
                throw throwable;
            }
        }
        finally {
            long elapsed = System.nanoTime() - start;
            this.totalAcquireNanos += elapsed;
            this.maxAcquireNanos = Math.max(this.maxAcquireNanos, elapsed);
            this.lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    private PooledConnection _obtainConnectionWaitLoop() throws SQLException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PoolStatus shutdown(boolean closeBusyConnections) {
        this.lock.lock();
        try {
            this.doingShutdown = true;
            PoolStatus status = this.createStatus();
            this.closeFreeConnections(true);
            if (!closeBusyConnections) {
                this.lastResetTime = System.currentTimeMillis() - 100L;
            } else if (!this.busyList.isEmpty()) {
                Log.warn("Closing busy connections on shutdown size: {0}", this.busyList.size());
                this.dumpBusyConnectionInformation();
                this.closeBusyConnections(0L);
            }
            PoolStatus poolStatus = status;
            return poolStatus;
        }
        finally {
            this.lock.unlock();
            this.doingShutdown = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset(long leakTimeMinutes) {
        this.lock.lock();
        try {
            PoolStatus status = this.createStatus();
            Log.info("Resetting DataSource [{0}] {1}", this.name, status);
            this.lastResetTime = System.currentTimeMillis();
            this.closeFreeConnections(false);
            this.closeBusyConnections(leakTimeMinutes);
            String busyInfo = this.getBusyConnectionInformation();
            if (!busyInfo.isEmpty()) {
                Log.info("Busy Connections:\n {0}", busyInfo);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trim(long maxInactiveMillis, long maxAgeMillis) {
        this.lock.lock();
        try {
            if (this.trimInactiveConnections(maxInactiveMillis, maxAgeMillis)) {
                try {
                    this.ensureMinimumConnections();
                }
                catch (SQLException e) {
                    Log.error("Error trying to ensure minimum connections", e);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean trimInactiveConnections(long maxInactiveMillis, long maxAgeMillis) {
        int trimmedCount;
        long createdSince;
        long l = createdSince = maxAgeMillis == 0L ? 0L : System.currentTimeMillis() - maxAgeMillis;
        if (this.freeList.size() > this.minSize) {
            long usedSince = System.currentTimeMillis() - maxInactiveMillis;
            trimmedCount = this.freeList.trim(this.minSize, usedSince, createdSince);
        } else {
            trimmedCount = createdSince > 0L ? this.freeList.trim(0, createdSince, createdSince) : 0;
        }
        if (trimmedCount > 0 && Log.isLoggable(System.Logger.Level.DEBUG)) {
            Log.debug("DataSource [{0}] trimmed [{1}] inactive connections. New size[{2}]", this.name, trimmedCount, this.totalConnections());
        }
        return trimmedCount > 0 && this.freeList.size() < this.minSize;
    }

    private void closeFreeConnections(boolean logErrors) {
        this.lock.lock();
        try {
            this.freeList.closeAll(logErrors);
        }
        finally {
            this.lock.unlock();
        }
    }

    void closeBusyConnections(long leakTimeMinutes) {
        this.lock.lock();
        try {
            this.busyList.closeBusyConnections(leakTimeMinutes);
        }
        finally {
            this.lock.unlock();
        }
    }

    String getBusyConnectionInformation() {
        return this.getBusyConnectionInformation(false);
    }

    void dumpBusyConnectionInformation() {
        this.getBusyConnectionInformation(true);
    }

    private String getBusyConnectionInformation(boolean toLogger) {
        this.lock.lock();
        try {
            String string = this.busyList.busyConnectionInformation(toLogger);
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }
}

