/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.dbmigration.runner;

import io.ebean.dbmigration.MigrationConfig;
import io.ebean.dbmigration.runner.Checksum;
import io.ebean.dbmigration.runner.LocalMigrationResource;
import io.ebean.dbmigration.runner.MigrationMetaRow;
import io.ebean.dbmigration.runner.MigrationScriptRunner;
import io.ebean.dbmigration.runner.PlaceholderBuilder;
import io.ebean.dbmigration.runner.ScriptTransform;
import io.ebean.dbmigration.util.IOUtils;
import io.ebean.dbmigration.util.JdbcClose;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationTable {
    private static final Logger logger = LoggerFactory.getLogger(MigrationTable.class);
    private final Connection connection;
    private final String catalog;
    private final String schema;
    private final String table;
    private final String envUserName;
    private final String platformName;
    private final Timestamp runOn = new Timestamp(System.currentTimeMillis());
    private final ScriptTransform scriptTransform;
    private final String insertSql;
    private final String selectSql;
    private final LinkedHashMap<String, MigrationMetaRow> migrations;
    private MigrationMetaRow lastMigration;

    public MigrationTable(MigrationConfig config, Connection connection) {
        this.connection = connection;
        this.migrations = new LinkedHashMap();
        this.catalog = null;
        this.schema = config.getDbSchema();
        this.table = config.getMetaTable();
        this.platformName = config.getPlatformName();
        this.selectSql = MigrationMetaRow.selectSql(this.table, this.platformName);
        this.insertSql = MigrationMetaRow.insertSql(this.table);
        this.scriptTransform = this.createScriptTransform(config);
        this.envUserName = System.getProperty("user.name");
    }

    public int size() {
        return this.migrations.size();
    }

    private ScriptTransform createScriptTransform(MigrationConfig config) {
        Map<String, String> map = PlaceholderBuilder.build(config.getRunPlaceholders(), config.getRunPlaceholderMap());
        return new ScriptTransform(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIfNeeded() throws SQLException, IOException {
        if (!this.tableExists(this.connection)) {
            this.createTable(this.connection);
        }
        PreparedStatement query = this.connection.prepareStatement(this.selectSql);
        try {
            ResultSet resultSet = query.executeQuery();
            try {
                while (resultSet.next()) {
                    MigrationMetaRow metaRow = new MigrationMetaRow(resultSet);
                    this.addMigration(metaRow.getVersion(), metaRow);
                }
            }
            finally {
                JdbcClose.close(resultSet);
            }
        }
        finally {
            JdbcClose.close(query);
        }
    }

    private void createTable(Connection connection) throws IOException, SQLException {
        String script = ScriptTransform.table(this.table, this.getCreateTableScript());
        MigrationScriptRunner run = new MigrationScriptRunner(connection);
        run.runScript(false, script, "create migration table");
    }

    private String getCreateTableScript() throws IOException {
        String script = this.readResource("migration-support/create-table.sql");
        if (script == null && this.platformName != null || !this.platformName.isEmpty()) {
            script = this.readResource("migration-support/" + this.platformName + "-create-table.sql");
        }
        if (script == null) {
            script = this.readResource("migration-support/default-create-table.sql");
        }
        return script;
    }

    private String readResource(String location) throws IOException {
        Enumeration<URL> resources = this.getClassLoader().getResources(location);
        if (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            return IOUtils.readUtf8(url.openStream());
        }
        return null;
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableExists(Connection connection) throws SQLException {
        String migTable = this.table;
        DatabaseMetaData metaData = connection.getMetaData();
        if (metaData.storesUpperCaseIdentifiers()) {
            migTable = migTable.toUpperCase();
        }
        ResultSet tables = metaData.getTables(this.catalog, this.schema, migTable, null);
        try {
            boolean bl = tables.next();
            return bl;
        }
        finally {
            JdbcClose.close(tables);
        }
    }

    public boolean shouldRun(LocalMigrationResource localVersion, LocalMigrationResource priorVersion) throws SQLException {
        if (priorVersion != null && !localVersion.isRepeatable() && !this.migrationExists(priorVersion)) {
            logger.error("Migration {} requires prior migration {} which has not been run", (Object)localVersion.getVersion(), (Object)priorVersion.getVersion());
            return false;
        }
        MigrationMetaRow existing = this.migrations.get(localVersion.key());
        return this.runMigration(localVersion, existing);
    }

    private boolean runMigration(LocalMigrationResource local, MigrationMetaRow existing) throws SQLException {
        String script = this.convertScript(local.getContent());
        int checksum = Checksum.calculate(script);
        if (existing != null) {
            boolean matchChecksum;
            boolean bl = matchChecksum = existing.getChecksum() == checksum;
            if (!local.isRepeatable()) {
                if (!matchChecksum) {
                    logger.error("Checksum mismatch on migration {}", (Object)local.getLocation());
                }
                return true;
            }
            if (matchChecksum) {
                logger.trace("... skip unchanged repeatable migration {}", (Object)local.getLocation());
                return true;
            }
        }
        this.runMigration(local, script, checksum);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMigration(LocalMigrationResource local, String script, int checksum) throws SQLException {
        logger.debug("run migration {}", (Object)local.getLocation());
        long start = System.currentTimeMillis();
        MigrationScriptRunner run = new MigrationScriptRunner(this.connection);
        run.runScript(false, script, "run migration version: " + local.getVersion());
        long exeMillis = System.currentTimeMillis() - start;
        MigrationMetaRow metaRow = this.createMetaRow(local, checksum, exeMillis);
        PreparedStatement statement = this.connection.prepareStatement(this.insertSql);
        try {
            metaRow.bindInsert(statement);
            statement.executeUpdate();
            this.addMigration(local.key(), metaRow);
        }
        finally {
            JdbcClose.close(statement);
        }
    }

    private MigrationMetaRow createMetaRow(LocalMigrationResource migration, int checksum, long exeMillis) {
        int nextId = 1;
        if (this.lastMigration != null) {
            nextId = this.lastMigration.getId() + 1;
        }
        String type = migration.getType();
        String runVersion = migration.key();
        String comment = migration.getComment();
        return new MigrationMetaRow(nextId, type, runVersion, comment, checksum, this.envUserName, this.runOn, exeMillis);
    }

    private boolean migrationExists(LocalMigrationResource priorVersion) {
        return this.migrations.containsKey(priorVersion.key());
    }

    private String convertScript(String script) {
        return this.scriptTransform.transform(script);
    }

    private void addMigration(String key, MigrationMetaRow metaRow) {
        this.lastMigration = metaRow;
        if (metaRow.getVersion() == null) {
            throw new IllegalStateException("No runVersion in db migration table row? " + metaRow);
        }
        this.migrations.put(key, metaRow);
    }
}

