/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.migrationreader;

import io.ebeaninternal.dbmigration.migration.Migration;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class MigrationXmlWriter {
    private final String comment;

    public MigrationXmlWriter(String comment) {
        this.comment = comment;
    }

    public void write(Migration migration, File file) {
        try (FileWriter writer = new FileWriter(file);){
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
            if (this.comment != null) {
                writer.write("<!-- ");
                writer.write(this.comment);
                writer.write(" -->\n");
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Migration.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            marshaller.marshal((Object)migration, (Writer)writer);
        }
        catch (IOException | JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

