/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration;

import io.ebean.annotation.Platform;
import io.ebean.config.DatabaseConfig;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.ddlrunner.DdlRunner;
import io.ebean.ddlrunner.ScriptTransform;
import io.ebean.util.JdbcClose;
import io.ebeaninternal.api.SpiDdlGenerator;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.dbmigration.Detect;
import io.ebeaninternal.dbmigration.model.CurrentModel;
import io.ebeaninternal.dbmigration.model.MTable;
import io.ebeaninternal.extraddl.model.ExtraDdlXmlReader;
import io.ebeaninternal.server.deploy.PartitionMeta;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DdlGenerator
implements SpiDdlGenerator {
    private static final Logger log = LoggerFactory.getLogger(DdlGenerator.class);
    private static final String[] BUILD_DIRS = new String[]{"target", "build"};
    private final SpiEbeanServer server;
    private final boolean generateDdl;
    private final boolean runDdl;
    private final boolean extraDdl;
    private final boolean createOnly;
    private final boolean jaxbPresent;
    private final boolean ddlAutoCommit;
    private final String dbSchema;
    private final ScriptTransform scriptTransform;
    private final Platform platform;
    private final String platformName;
    private CurrentModel currentModel;
    private String dropAllContent;
    private String createAllContent;
    private final File baseDir;

    public DdlGenerator(SpiEbeanServer server) {
        this.server = server;
        DatabaseConfig config = server.config();
        this.jaxbPresent = Detect.isJAXBPresent(config);
        this.generateDdl = config.isDdlGenerate();
        this.extraDdl = config.isDdlExtra();
        this.createOnly = config.isDdlCreateOnly();
        this.dbSchema = config.getDbSchema();
        DatabasePlatform databasePlatform = server.databasePlatform();
        this.platform = databasePlatform.getPlatform();
        this.platformName = this.platform.base().name();
        if (!config.getTenantMode().isDdlEnabled() && config.isDdlRun()) {
            log.warn("DDL can't be run on startup with TenantMode " + config.getTenantMode());
            this.runDdl = false;
            this.ddlAutoCommit = false;
        } else {
            this.runDdl = config.isDdlRun();
            this.ddlAutoCommit = databasePlatform.isDdlAutoCommit();
        }
        this.scriptTransform = this.createScriptTransform(config);
        this.baseDir = this.initBaseDir();
    }

    private File initBaseDir() {
        for (String buildDir : BUILD_DIRS) {
            File dir = new File(buildDir);
            if (!dir.exists() || !dir.isDirectory()) continue;
            return dir;
        }
        return new File(".");
    }

    public void execute(boolean online) {
        this.generateDdl();
        if (online) {
            this.runDdl();
        }
    }

    protected void generateDdl() {
        if (this.generateDdl) {
            if (!this.createOnly) {
                this.writeDrop(this.getDropFileName());
            }
            this.writeCreate(this.getCreateFileName());
        }
    }

    protected void runDdl() {
        if (this.runDdl) {
            Connection connection = null;
            try {
                connection = this.obtainConnection();
                this.runDdlWith(connection);
            }
            finally {
                JdbcClose.rollback((Connection)connection);
                JdbcClose.close((Connection)connection);
            }
        }
    }

    private void runDdlWith(Connection connection) {
        try {
            if (this.dbSchema != null) {
                this.createSchemaIfRequired(connection);
            }
            this.runInitSql(connection);
            this.runDropSql(connection);
            this.runCreateSql(connection);
            this.runSeedSql(connection);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading drop/create script from file system", e);
        }
    }

    private Connection obtainConnection() {
        try {
            return this.server.dataSource().getConnection();
        }
        catch (SQLException e) {
            throw new PersistenceException("Failed to obtain connection to run DDL", (Throwable)e);
        }
    }

    private void createSchemaIfRequired(Connection connection) {
        try {
            for (String schema : this.dbSchema.split(",")) {
                this.server.databasePlatform().createSchemaIfNotExists(schema, connection);
            }
        }
        catch (SQLException e) {
            throw new PersistenceException("Failed to create DB Schema", (Throwable)e);
        }
    }

    void runScript(Connection connection, boolean expectErrors, String content, String scriptName) {
        DdlRunner runner = this.createDdlRunner(expectErrors, scriptName);
        try {
            if (expectErrors || this.ddlAutoCommit) {
                connection.setAutoCommit(true);
            }
            runner.runAll(this.scriptTransform.transform(content), connection);
            if (expectErrors || this.ddlAutoCommit) {
                connection.setAutoCommit(false);
            }
            connection.commit();
            runner.runNonTransactional(connection);
        }
        catch (SQLException e) {
            throw new PersistenceException("Failed to run script", (Throwable)e);
        }
        finally {
            JdbcClose.rollback((Connection)connection);
        }
    }

    private DdlRunner createDdlRunner(boolean expectErrors, String scriptName) {
        return new DdlRunner(expectErrors, scriptName, this.platformName);
    }

    protected void runDropSql(Connection connection) throws IOException {
        if (!this.createOnly) {
            String extraApply;
            if (this.extraDdl && this.jaxbPresent && (extraApply = ExtraDdlXmlReader.buildExtra(this.platform, true)) != null) {
                this.runScript(connection, false, extraApply, "extra-ddl");
            }
            if (this.dropAllContent == null) {
                this.dropAllContent = this.readFile(this.getDropFileName());
            }
            this.runScript(connection, true, this.dropAllContent, this.getDropFileName());
        }
    }

    protected void runCreateSql(Connection connection) throws IOException {
        if (this.createAllContent == null) {
            this.createAllContent = this.readFile(this.getCreateFileName());
        }
        this.runScript(connection, false, this.createAllContent, this.getCreateFileName());
        if (this.extraDdl && this.jaxbPresent) {
            String extraApply;
            String extraPartitioning;
            if (this.currentModel().isTablePartitioning() && (extraPartitioning = ExtraDdlXmlReader.buildPartitioning(this.platform)) != null && !extraPartitioning.isEmpty()) {
                this.runScript(connection, false, extraPartitioning, "builtin-partitioning-ddl");
            }
            if ((extraApply = ExtraDdlXmlReader.buildExtra(this.platform, false)) != null) {
                this.runScript(connection, false, extraApply, "extra-ddl");
            }
            if (this.currentModel().isTablePartitioning()) {
                this.checkInitialTablePartitions(connection);
            }
        }
    }

    private void checkInitialTablePartitions(Connection connection) {
        DatabasePlatform databasePlatform = this.server.databasePlatform();
        try {
            StringBuilder sb = new StringBuilder();
            for (MTable table : this.currentModel.getPartitionedTables()) {
                String tableName = table.getName();
                if (databasePlatform.tablePartitionsExist(connection, tableName)) continue;
                log.info("No table partitions for table {}", (Object)tableName);
                PartitionMeta meta = table.getPartitionMeta();
                String initPart = databasePlatform.tablePartitionInit(tableName, meta.getMode(), meta.getProperty(), table.singlePrimaryKey());
                sb.append(initPart).append("\n");
            }
            String initialPartitionSql = sb.toString();
            if (!initialPartitionSql.isEmpty()) {
                this.runScript(connection, false, initialPartitionSql, "initial table partitions");
            }
        }
        catch (SQLException e) {
            log.error("Error checking initial table partitions", (Throwable)e);
        }
    }

    protected void runInitSql(Connection connection) throws IOException {
        this.runResourceScript(connection, this.server.config().getDdlInitSql());
    }

    protected void runSeedSql(Connection connection) throws IOException {
        this.runResourceScript(connection, this.server.config().getDdlSeedSql());
    }

    protected void runResourceScript(Connection connection, String sqlScript) throws IOException {
        if (sqlScript != null) {
            try (InputStream is = this.getClassLoader().getResourceAsStream(sqlScript);){
                if (is == null) {
                    log.warn("sql script {} was not found as a resource", (Object)sqlScript);
                } else {
                    String content = this.readContent(new InputStreamReader(is));
                    this.runScript(connection, false, content, sqlScript);
                }
            }
        }
    }

    protected ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClassLoader();
        }
        return cl;
    }

    protected void writeDrop(String dropFile) {
        try {
            this.writeFile(dropFile, this.generateDropAllDdl());
        }
        catch (IOException e) {
            throw new PersistenceException("Error generating Drop DDL", (Throwable)e);
        }
    }

    protected void writeCreate(String createFile) {
        try {
            this.writeFile(createFile, this.generateCreateAllDdl());
        }
        catch (IOException e) {
            throw new PersistenceException("Error generating Create DDL", (Throwable)e);
        }
    }

    protected String generateDropAllDdl() {
        try {
            this.dropAllContent = this.currentModel().getDropAllDdl();
            return this.dropAllContent;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String generateCreateAllDdl() {
        try {
            this.createAllContent = this.currentModel().getCreateDdl();
            return this.createAllContent;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getDropFileName() {
        return this.server.name() + "-drop-all.sql";
    }

    protected String getCreateFileName() {
        return this.server.name() + "-create-all.sql";
    }

    protected CurrentModel currentModel() {
        if (this.currentModel == null) {
            this.currentModel = new CurrentModel(this.server);
        }
        return this.currentModel;
    }

    protected void writeFile(String fileName, String fileContent) throws IOException {
        File f = new File(this.baseDir, fileName);
        try (FileWriter fw = new FileWriter(f);){
            fw.write(fileContent);
            fw.flush();
        }
    }

    protected String readFile(String fileName) throws IOException {
        File f = new File(this.baseDir, fileName);
        if (!f.exists()) {
            return null;
        }
        return this.readContent(new FileReader(f));
    }

    protected String readContent(Reader reader) throws IOException {
        StringBuilder buf = new StringBuilder();
        try (LineNumberReader lineReader = new LineNumberReader(reader);){
            String s;
            while ((s = lineReader.readLine()) != null) {
                buf.append(s).append("\n");
            }
            String string = buf.toString();
            return string;
        }
    }

    private ScriptTransform createScriptTransform(DatabaseConfig config) {
        return ScriptTransform.build((String)config.getDdlPlaceholders(), (Map)config.getDdlPlaceholderMap());
    }
}

