/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.model.MConfiguration;
import java.io.IOException;
import java.io.StringWriter;

public class BaseDdlBuffer
implements DdlBuffer {
    protected final StringWriter writer;
    protected final MConfiguration configuration;

    public BaseDdlBuffer(MConfiguration configuration) {
        this.configuration = configuration;
        this.writer = new StringWriter();
    }

    @Override
    public MConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isEmpty() {
        return this.writer.getBuffer().length() == 0;
    }

    @Override
    public DdlBuffer appendWithSpace(String foreignKeyRestrict) throws IOException {
        if (foreignKeyRestrict != null && !foreignKeyRestrict.isEmpty()) {
            this.writer.append(" ").append(foreignKeyRestrict);
        }
        return this;
    }

    @Override
    public DdlBuffer appendStatement(String content) throws IOException {
        if (content != null && !content.isEmpty()) {
            this.writer.append(content);
            this.endOfStatement();
        }
        return this;
    }

    @Override
    public DdlBuffer append(String content) throws IOException {
        this.writer.append(content);
        return this;
    }

    @Override
    public DdlBuffer append(String content, int space) throws IOException {
        this.writer.append(content);
        this.appendSpace(space, content);
        return this;
    }

    protected void appendSpace(int max, String content) throws IOException {
        int space = max - content.length();
        if (space > 0) {
            for (int i = 0; i < space; ++i) {
                this.append(" ");
            }
        }
        this.append(" ");
    }

    @Override
    public DdlBuffer endOfStatement() throws IOException {
        this.writer.append(";\n");
        return this;
    }

    @Override
    public DdlBuffer end() throws IOException {
        if (!this.isEmpty()) {
            this.writer.append("\n");
        }
        return this;
    }

    @Override
    public DdlBuffer newLine() throws IOException {
        this.writer.append("\n");
        return this;
    }

    @Override
    public String getBuffer() {
        return this.writer.toString();
    }
}

