/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration;

import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlOptions;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.BaseDdlBuffer;
import io.ebeaninternal.dbmigration.model.MConfiguration;
import io.ebeaninternal.dbmigration.model.MTable;
import io.ebeaninternal.dbmigration.model.ModelContainer;

public class DdlWrite {
    private final ModelContainer currentModel;
    private final DdlBuffer applyDropDependencies = new BaseDdlBuffer();
    private final DdlBuffer apply = new BaseDdlBuffer();
    private final DdlBuffer applyForeignKeys = new BaseDdlBuffer();
    private final DdlBuffer applyHistoryView = new BaseDdlBuffer();
    private final DdlBuffer applyHistoryTrigger = new BaseDdlBuffer();
    private final DdlBuffer dropAllForeignKeys = new BaseDdlBuffer();
    private final DdlBuffer dropAll = new BaseDdlBuffer();
    private final DdlOptions options;

    public DdlWrite() {
        this(new MConfiguration(), new ModelContainer(), new DdlOptions());
    }

    public DdlWrite(MConfiguration configuration, ModelContainer currentModel, DdlOptions options) {
        this.currentModel = currentModel;
        this.options = options;
    }

    public DdlOptions getOptions() {
        return this.options;
    }

    public MTable getTable(String tableName) {
        return this.currentModel.getTable(tableName);
    }

    public boolean isApplyEmpty() {
        return this.apply.getBuffer().isEmpty() && this.applyForeignKeys.getBuffer().isEmpty() && this.applyHistoryView.getBuffer().isEmpty() && this.applyHistoryTrigger.getBuffer().isEmpty() && this.applyDropDependencies.getBuffer().isEmpty();
    }

    public DdlBuffer apply() {
        return this.apply;
    }

    public DdlBuffer applyDropDependencies() {
        return this.applyDropDependencies;
    }

    public DdlBuffer applyForeignKeys() {
        return this.applyForeignKeys;
    }

    public DdlBuffer applyHistoryView() {
        return this.applyHistoryView;
    }

    public DdlBuffer applyHistoryTrigger() {
        return this.applyHistoryTrigger;
    }

    public DdlBuffer dropAllForeignKeys() {
        return this.dropAllForeignKeys;
    }

    public DdlBuffer dropAll() {
        return this.dropAll;
    }
}

