/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.annotation.ConstraintMode;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;

public class DB2Ddl
extends PlatformDdl {
    public DB2Ddl(DatabasePlatform platform) {
        super(platform);
        this.dropTableIfExists = "drop table ";
        this.dropSequenceIfExists = "drop sequence ";
        this.dropConstraintIfExists = "drop constraint";
        this.dropIndexIfExists = "drop index ";
        this.identitySuffix = " generated by default as identity";
        this.columnSetNull = "drop not null";
        this.columnSetType = "set data type ";
        this.inlineUniqueWhenNullable = false;
    }

    @Override
    public String alterTableAddUniqueConstraint(String tableName, String uqName, String[] columns, String[] nullableColumns) {
        if (nullableColumns == null || nullableColumns.length == 0) {
            return super.alterTableAddUniqueConstraint(tableName, uqName, columns, nullableColumns);
        }
        if (uqName == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder("create unique index ");
        sb.append(uqName).append(" on ").append(tableName).append('(');
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(columns[i]);
        }
        sb.append(") exclude null keys");
        return sb.toString();
    }

    @Override
    protected void appendForeignKeyOnUpdate(StringBuilder buffer, ConstraintMode mode) {
    }
}

