/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.config.DatabaseConfig;
import io.ebean.config.DbConstraintNaming;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DbTriggerUpdate;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.HistoryTableUpdate;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformHistoryDdl;
import io.ebeaninternal.dbmigration.migration.AddHistoryTable;
import io.ebeaninternal.dbmigration.migration.DropHistoryTable;
import io.ebeaninternal.dbmigration.model.MColumn;
import io.ebeaninternal.dbmigration.model.MTable;
import java.util.List;

public abstract class DbTriggerBasedHistoryDdl
implements PlatformHistoryDdl {
    protected DbConstraintNaming constraintNaming;
    protected PlatformDdl platformDdl;
    protected String sysPeriod;
    protected String sysPeriodStart;
    protected String sysPeriodEnd;
    protected String viewSuffix;
    protected String historySuffix;
    protected String sysPeriodType = "datetime(6)";
    protected String now = "now(6)";
    protected String sysPeriodEndValue = "now(6)";

    DbTriggerBasedHistoryDdl() {
    }

    @Override
    public void configure(DatabaseConfig config, PlatformDdl platformDdl) {
        this.platformDdl = platformDdl;
        this.sysPeriod = config.getAsOfSysPeriod();
        this.viewSuffix = config.getAsOfViewSuffix();
        this.historySuffix = config.getHistoryTableSuffix();
        this.constraintNaming = config.getConstraintNaming();
        this.sysPeriodStart = this.sysPeriod + "_start";
        this.sysPeriodEnd = this.sysPeriod + "_end";
    }

    @Override
    public void updateTriggers(DdlWrite writer, HistoryTableUpdate update) {
        MTable table = writer.getTable(update.getBaseTable());
        if (table == null) {
            throw new IllegalStateException("MTable " + update.getBaseTable() + " not found in writer? (required for history DDL)");
        }
        this.updateTriggers(writer, table, update);
    }

    protected abstract void updateHistoryTriggers(DbTriggerUpdate var1);

    protected void updateTriggers(DdlWrite writer, MTable table, HistoryTableUpdate update) {
        writer.applyHistoryTrigger().append("-- changes: ").append(update.description()).newLine();
        this.updateHistoryTriggers(this.createDbTriggerUpdate(writer, table));
    }

    protected DbTriggerUpdate createDbTriggerUpdate(DdlWrite writer, MTable table) {
        List<String> columns = this.columnNamesForApply(table);
        String baseTableName = table.getName();
        String historyTableName = this.historyTableName(baseTableName);
        return new DbTriggerUpdate(baseTableName, historyTableName, writer, columns);
    }

    @Override
    public void dropHistoryTable(DdlWrite writer, DropHistoryTable dropHistoryTable) {
        String baseTable = dropHistoryTable.getBaseTable();
        this.dropTriggers(writer.applyDropDependencies(), baseTable);
        this.dropHistoryTableEtc(writer.applyDropDependencies(), baseTable);
    }

    @Override
    public void addHistoryTable(DdlWrite writer, AddHistoryTable addHistoryTable) {
        String baseTable = addHistoryTable.getBaseTable();
        MTable table = writer.getTable(baseTable);
        if (table == null) {
            throw new IllegalStateException("MTable " + baseTable + " not found in writer? (required for history DDL)");
        }
        this.createWithHistory(writer, table);
    }

    @Override
    public void createWithHistory(DdlWrite writer, MTable table) {
        String baseTable = table.getName();
        String whenCreatedColumn = table.getWhenCreatedColumn();
        this.dropTriggers(writer.dropAll(), baseTable);
        this.dropHistoryTableEtc(writer.dropAll(), baseTable);
        this.addHistoryTable(writer, table, whenCreatedColumn);
        this.createStoredFunction(writer, table);
        this.createTriggers(writer, table);
    }

    protected abstract void createTriggers(DdlWrite var1, MTable var2);

    protected abstract void dropTriggers(DdlBuffer var1, String var2);

    protected void createStoredFunction(DdlWrite writer, MTable table) {
    }

    protected String normalise(String tableName) {
        return this.constraintNaming.normaliseTable(tableName);
    }

    protected String historyTableName(String baseTableName) {
        return baseTableName + this.historySuffix;
    }

    protected String procedureName(String baseTableName) {
        return baseTableName + "_history_version";
    }

    protected String triggerName(String baseTableName) {
        return this.normalise(baseTableName) + "_history_upd";
    }

    protected String updateTriggerName(String baseTableName) {
        return this.normalise(baseTableName) + "_history_upd";
    }

    protected String deleteTriggerName(String baseTableName) {
        return this.normalise(baseTableName) + "_history_del";
    }

    protected void addHistoryTable(DdlWrite writer, MTable table, String whenCreatedColumn) {
        String baseTableName = table.getName();
        DdlBuffer apply = writer.applyHistoryView();
        this.addSysPeriodColumns(apply, baseTableName, whenCreatedColumn);
        this.createHistoryTable(apply, table);
        this.createWithHistoryView(apply, baseTableName);
    }

    protected void addSysPeriodColumns(DdlBuffer apply, String baseTableName, String whenCreatedColumn) {
        apply.append("alter table ").append(baseTableName).append(" add column ").append(this.sysPeriodStart).append(" ").append(this.sysPeriodType).append(" default ").append(this.now).endOfStatement();
        apply.append("alter table ").append(baseTableName).append(" add column ").append(this.sysPeriodEnd).append(" ").append(this.sysPeriodType).endOfStatement();
        if (whenCreatedColumn != null) {
            apply.append("update ").append(baseTableName).append(" set ").append(this.sysPeriodStart).append(" = ").append(whenCreatedColumn).endOfStatement();
        }
    }

    protected void createHistoryTable(DdlBuffer apply, MTable table) {
        this.createHistoryTableAs(apply, table);
        this.createHistoryTableWithPeriod(apply);
    }

    protected void createHistoryTableAs(DdlBuffer apply, MTable table) {
        apply.append(this.platformDdl.getCreateTableCommandPrefix()).append(" ").append(table.getName()).append(this.historySuffix).append("(").newLine();
        for (MColumn column : table.allColumns()) {
            if (column.isDraftOnly()) continue;
            this.writeColumnDefinition(apply, column.getName(), column.getType());
            apply.append(",").newLine();
        }
    }

    protected void createHistoryTableWithPeriod(DdlBuffer apply) {
        this.writeColumnDefinition(apply, this.sysPeriodStart, this.sysPeriodType);
        apply.append(",").newLine();
        this.writeColumnDefinition(apply, this.sysPeriodEnd, this.sysPeriodType);
        apply.newLine().append(")").endOfStatement();
    }

    protected void writeColumnDefinition(DdlBuffer buffer, String columnName, String type) {
        String platformType = this.platformDdl.convert(type);
        buffer.append("  ");
        buffer.append(this.platformDdl.lowerColumnName(columnName), 29);
        buffer.append(platformType);
    }

    protected void createWithHistoryView(DdlBuffer apply, String baseTableName) {
        apply.append("create view ").append(baseTableName).append(this.viewSuffix).append(" as select * from ").append(baseTableName).append(" union all select * from ").append(baseTableName).append(this.historySuffix).endOfStatement().end();
    }

    protected void recreateHistoryView(DbTriggerUpdate update) {
        DdlBuffer buffer = update.dropDependencyBuffer();
        buffer.append("drop view if exists ").append(update.getBaseTable()).append(this.viewSuffix).endOfStatement();
        this.createWithHistoryView(update.historyViewBuffer(), update.getBaseTable());
    }

    protected void appendSysPeriodColumns(DdlBuffer apply, String prefix) {
        this.appendColumnName(apply, prefix, this.sysPeriodStart);
        this.appendColumnName(apply, prefix, this.sysPeriodEnd);
    }

    protected void dropHistoryTableEtc(DdlBuffer buffer, String baseTableName) {
        buffer.append("drop view ").append(baseTableName).append(this.viewSuffix).endOfStatement();
        this.dropSysPeriodColumns(buffer, baseTableName);
        buffer.append("drop table ").append(baseTableName).append(this.historySuffix).endOfStatement().end();
    }

    protected void dropSysPeriodColumns(DdlBuffer buffer, String baseTableName) {
        this.platformDdl.alterTableDropColumn(buffer, baseTableName, this.sysPeriodStart);
        this.platformDdl.alterTableDropColumn(buffer, baseTableName, this.sysPeriodEnd);
    }

    protected void appendInsertIntoHistory(DdlBuffer buffer, String historyTable, List<String> columns) {
        buffer.append("    insert into ").append(historyTable).append(" (").append(this.sysPeriodStart).append(",").append(this.sysPeriodEnd).append(",");
        this.appendColumnNames(buffer, columns, "");
        buffer.append(") values (OLD.").append(this.sysPeriodStart).append(", ").append(this.sysPeriodEndValue).append(",");
        this.appendColumnNames(buffer, columns, "OLD.");
        buffer.append(");").newLine();
    }

    void appendColumnNames(DdlBuffer buffer, List<String> columns, String columnPrefix) {
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(columnPrefix);
            buffer.append(columns.get(i));
        }
    }

    void appendColumnName(DdlBuffer buffer, String prefix, String columnName) {
        if (columnName != null) {
            buffer.append(prefix).append(columnName);
        }
    }

    List<String> columnNamesForApply(MTable table) {
        return table.allHistoryColumns(true);
    }
}

