/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DbTriggerBasedHistoryDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DbTriggerUpdate;
import io.ebeaninternal.dbmigration.model.MTable;

public class H2HistoryDdl
extends DbTriggerBasedHistoryDdl {
    private static final String TRIGGER_CLASS = "io.ebean.config.dbplatform.h2.H2HistoryTrigger";

    H2HistoryDdl() {
        this.sysPeriodType = "timestamp";
        this.now = "now()";
        this.sysPeriodEndValue = "now()";
    }

    @Override
    protected void dropTriggers(DdlBuffer buffer, String baseTable) {
        buffer.append("drop trigger ").append(this.updateTriggerName(baseTable)).endOfStatement();
    }

    @Override
    protected void createTriggers(DdlWrite writer, MTable table) {
        String baseTableName = table.getName();
        DdlBuffer apply = writer.applyHistoryTrigger();
        this.addCreateTrigger(apply, this.updateTriggerName(baseTableName), baseTableName);
    }

    @Override
    protected void updateHistoryTriggers(DbTriggerUpdate update) {
        this.recreateHistoryView(update);
        DdlBuffer buffer = update.historyTriggerBuffer();
        this.dropTriggers(buffer, update.getBaseTable());
        this.addCreateTrigger(buffer, this.updateTriggerName(update.getBaseTable()), update.getBaseTable());
    }

    private void addCreateTrigger(DdlBuffer apply, String triggerName, String baseTable) {
        apply.append("create trigger ").append(triggerName).append(" before update,delete on ").append(baseTable).append(" for each row call \"io.ebean.config.dbplatform.h2.H2HistoryTrigger\";").newLine();
    }
}

