/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.config.DatabaseConfig;
import io.ebean.config.PropertiesWrapper;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.BaseTableDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.HanaHistoryDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.migration.AddColumn;
import io.ebeaninternal.dbmigration.migration.AlterColumn;
import io.ebeaninternal.dbmigration.migration.Column;
import io.ebeaninternal.dbmigration.migration.DropColumn;
import io.ebeaninternal.dbmigration.model.MTable;
import java.util.List;

public class HanaTableDdl
extends BaseTableDdl {
    private final HanaHistoryDdl historyDdl;
    private final boolean generateUniqueDdl;

    public HanaTableDdl(DatabaseConfig config, PlatformDdl platformDdl) {
        super(config, platformDdl);
        this.historyDdl = (HanaHistoryDdl)platformDdl.historyDdl;
        if (config.getProperties() != null) {
            PropertiesWrapper wrapper = new PropertiesWrapper("ebean", "hana", config.getProperties(), config.getClassLoadConfig());
            this.generateUniqueDdl = wrapper.getBoolean("generateUniqueDdl", false);
        } else {
            this.generateUniqueDdl = false;
        }
    }

    @Override
    protected void alterColumnDefaultValue(DdlWrite writer, AlterColumn alter) {
    }

    @Override
    public void generate(DdlWrite writer, AddColumn addColumn) {
        boolean manageSystemVersioning;
        String tableName = addColumn.getTableName();
        MTable table = writer.getTable(tableName);
        if (table == null) {
            super.generate(writer, addColumn);
            return;
        }
        boolean bl = manageSystemVersioning = this.isTrue(table.isWithHistory()) && this.historyDdl.isSystemVersioningEnabled(tableName);
        if (manageSystemVersioning) {
            this.historyDdl.disableSystemVersioning(writer.apply(), table.getName(), this.generateUniqueDdl);
        }
        super.generate(writer, addColumn);
        if (manageSystemVersioning) {
            String historyTable = this.historyTable(tableName);
            List<Column> columns = addColumn.getColumn();
            for (Column column : columns) {
                this.alterTableAddColumn(writer.apply(), historyTable, column, true, true);
            }
            this.historyDdl.enableSystemVersioning(writer.apply(), table.getName(), historyTable, false, this.generateUniqueDdl);
        }
    }

    @Override
    public void generate(DdlWrite writer, AlterColumn alterColumn) {
        boolean manageSystemVersioning;
        String tableName = alterColumn.getTableName();
        MTable table = writer.getTable(tableName);
        if (table == null) {
            super.generate(writer, alterColumn);
            return;
        }
        boolean bl = manageSystemVersioning = this.isTrue(table.isWithHistory()) && this.historyDdl.isSystemVersioningEnabled(tableName);
        if (manageSystemVersioning) {
            this.historyDdl.disableSystemVersioning(writer.apply(), tableName, this.generateUniqueDdl);
        }
        super.generate(writer, alterColumn);
        if (manageSystemVersioning) {
            String historyTable = this.historyTable(tableName);
            if (this.hasValue(alterColumn.getType()) || this.hasValue(alterColumn.getDefaultValue()) || alterColumn.isNotnull() != null) {
                AlterColumn alterHistoryColumn = new AlterColumn();
                alterHistoryColumn.setTableName(historyTable);
                alterHistoryColumn.setColumnName(alterColumn.getColumnName());
                alterHistoryColumn.setType(alterColumn.getType());
                alterHistoryColumn.setDefaultValue(alterColumn.getDefaultValue());
                alterHistoryColumn.setNotnull(alterColumn.isNotnull());
                alterHistoryColumn.setCurrentType(alterColumn.getCurrentType());
                alterHistoryColumn.setCurrentDefaultValue(alterColumn.getCurrentDefaultValue());
                alterHistoryColumn.setCurrentNotnull(alterColumn.isCurrentNotnull());
                String histColumnDdl = this.platformDdl.alterColumnBaseAttributes(alterHistoryColumn);
                writer.apply().append(histColumnDdl).endOfStatement();
            }
            this.historyDdl.enableSystemVersioning(writer.apply(), tableName, historyTable, false, this.generateUniqueDdl);
        }
    }

    @Override
    public void generate(DdlWrite writer, DropColumn dropColumn) {
        boolean manageSystemVersioning;
        String tableName = dropColumn.getTableName();
        MTable table = writer.getTable(tableName);
        if (table == null) {
            super.generate(writer, dropColumn);
            return;
        }
        boolean bl = manageSystemVersioning = this.isTrue(table.isWithHistory()) && this.historyDdl.isSystemVersioningEnabled(tableName);
        if (manageSystemVersioning) {
            this.historyDdl.disableSystemVersioning(writer.apply(), tableName, this.generateUniqueDdl);
        }
        super.generate(writer, dropColumn);
        if (manageSystemVersioning) {
            String historyTable = this.historyTable(tableName);
            this.alterTableDropColumn(writer.apply(), historyTable, dropColumn.getColumnName());
            this.historyDdl.enableSystemVersioning(writer.apply(), tableName, historyTable, false, this.generateUniqueDdl);
        }
    }
}

