/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.config.DatabaseConfig;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.HistoryTableUpdate;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformHistoryDdl;
import io.ebeaninternal.dbmigration.migration.AddHistoryTable;
import io.ebeaninternal.dbmigration.migration.DropHistoryTable;
import io.ebeaninternal.dbmigration.model.MTable;

public class MariaDbHistoryDdl
implements PlatformHistoryDdl {
    @Override
    public void configure(DatabaseConfig config, PlatformDdl platformDdl) {
    }

    @Override
    public void createWithHistory(DdlWrite writer, MTable table) {
        String baseTable = table.getName();
        this.enableSystemVersioning(writer, baseTable);
    }

    private void enableSystemVersioning(DdlWrite writer, String baseTable) {
        DdlBuffer apply = writer.applyHistoryView();
        apply.append("alter table ").append(baseTable).append(" add system versioning").endOfStatement();
        DdlBuffer drop = writer.dropAll();
        drop.append("alter table ").append(baseTable).append(" drop system versioning").endOfStatement();
    }

    @Override
    public void dropHistoryTable(DdlWrite writer, DropHistoryTable dropHistoryTable) {
        String baseTable = dropHistoryTable.getBaseTable();
        DdlBuffer apply = writer.applyHistoryView();
        apply.append("alter table ").append(baseTable).append(" drop system versioning").endOfStatement();
    }

    @Override
    public void addHistoryTable(DdlWrite writer, AddHistoryTable addHistoryTable) {
        String baseTable = addHistoryTable.getBaseTable();
        this.enableSystemVersioning(writer, baseTable);
    }

    @Override
    public void updateTriggers(DdlWrite writer, HistoryTableUpdate baseTable) {
    }
}

