/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.util.StringHelper;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlHelp;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlIdentity;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.MySqlHistoryDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.migration.AlterColumn;
import io.ebeaninternal.dbmigration.migration.Column;
import java.util.Collection;

public class MySqlDdl
extends PlatformDdl {
    private static final boolean USE_CHECK_CONSTRAINT = Boolean.getBoolean("ebean.mysql.useCheckConstraint");
    private final boolean useMigrationStoredProcedures;

    public MySqlDdl(DatabasePlatform platform) {
        super(platform);
        this.alterColumn = "modify";
        this.dropUniqueConstraint = "drop index";
        this.historyDdl = new MySqlHistoryDdl();
        this.inlineComments = true;
        this.useMigrationStoredProcedures = platform.isUseMigrationStoredProcedures();
    }

    @Override
    public String dropIndex(String indexName, String tableName, boolean concurrent) {
        return "drop index " + this.maxConstraintName(indexName) + " on " + tableName;
    }

    @Override
    public void alterTableDropColumn(DdlBuffer buffer, String tableName, String columnName) {
        if (this.useMigrationStoredProcedures) {
            buffer.append("CALL usp_ebean_drop_column('").append(tableName).append("', '").append(columnName).append("')").endOfStatement();
        } else {
            super.alterTableDropColumn(buffer, tableName, columnName);
        }
    }

    @Override
    public String alterTableDropForeignKey(String tableName, String fkName) {
        return "alter table " + tableName + " drop foreign key " + this.maxConstraintName(fkName);
    }

    @Override
    public String createCheckConstraint(String ckName, String checkConstraint) {
        if (USE_CHECK_CONSTRAINT) {
            return super.createCheckConstraint(ckName, checkConstraint);
        }
        return null;
    }

    @Override
    public String alterTableAddCheckConstraint(String tableName, String checkConstraintName, String checkConstraint) {
        if (USE_CHECK_CONSTRAINT) {
            return super.alterTableAddCheckConstraint(tableName, checkConstraintName, checkConstraint);
        }
        return null;
    }

    @Override
    public String alterTableDropConstraint(String tableName, String constraintName) {
        if (USE_CHECK_CONSTRAINT) {
            StringBuilder sb = new StringBuilder();
            sb.append("/*!80016 alter table ").append(tableName);
            sb.append(" drop check ").append(constraintName).append(" */;\n");
            sb.append("/*M!100201 ");
            sb.append(super.alterTableDropConstraint(tableName, constraintName));
            sb.append(" */");
            return sb.toString();
        }
        return null;
    }

    @Override
    public String alterColumnType(String tableName, String columnName, String type) {
        return null;
    }

    @Override
    public String alterColumnNotnull(String tableName, String columnName, boolean notnull) {
        return null;
    }

    @Override
    public String alterColumnDefaultValue(String tableName, String columnName, String defaultValue) {
        String suffix = DdlHelp.isDropDefault(defaultValue) ? this.columnDropDefault : this.columnSetDefault + " " + this.convertDefaultValue(defaultValue);
        return "alter table " + tableName + " alter " + columnName + " " + suffix;
    }

    @Override
    public String alterColumnBaseAttributes(AlterColumn alter) {
        if (alter.getType() == null && alter.isNotnull() == null) {
            return null;
        }
        String tableName = alter.getTableName();
        String columnName = alter.getColumnName();
        String type = alter.getType() != null ? alter.getType() : alter.getCurrentType();
        type = this.convert(type);
        boolean notnull = alter.isNotnull() != null ? alter.isNotnull().booleanValue() : Boolean.TRUE.equals(alter.isCurrentNotnull());
        String notnullClause = notnull ? " not null" : "";
        return "alter table " + tableName + " modify " + columnName + " " + type + notnullClause;
    }

    @Override
    protected void writeColumnDefinition(DdlBuffer buffer, Column column, DdlIdentity identity) {
        super.writeColumnDefinition(buffer, column, identity);
        String comment = column.getComment();
        if (!StringHelper.isNull((String)comment)) {
            if (comment.length() > 500) {
                comment = comment.substring(0, 500);
            }
            buffer.append(String.format(" comment '%s'", comment));
        }
    }

    @Override
    public void inlineTableComment(DdlBuffer apply, String tableComment) {
        if (tableComment.length() > 1000) {
            tableComment = tableComment.substring(0, 1000);
        }
        apply.append(" comment='").append(tableComment).append("'");
    }

    @Override
    public void addTableComment(DdlBuffer apply, String tableName, String tableComment) {
        if (DdlHelp.isDropComment(tableComment)) {
            tableComment = "";
        }
        apply.append(String.format("alter table %s comment = '%s'", tableName, tableComment)).endOfStatement();
    }

    @Override
    public void addColumnComment(DdlBuffer apply, String table, String column, String comment) {
    }

    @Override
    public void lockTables(DdlBuffer buffer, Collection<String> tables) {
        if (!tables.isEmpty()) {
            buffer.append("lock tables ");
            int i = 0;
            for (String table : tables) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(table).append(" write");
                ++i;
            }
            buffer.endOfStatement();
        }
    }

    @Override
    public void unlockTables(DdlBuffer buffer, Collection<String> tables) {
        buffer.append("unlock tables").endOfStatement();
    }
}

