/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DbTriggerBasedHistoryDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DbTriggerUpdate;
import io.ebeaninternal.dbmigration.model.MTable;

public class NuoDbHistoryDdl
extends DbTriggerBasedHistoryDdl {
    NuoDbHistoryDdl() {
        this.now = "now()";
        this.sysPeriodEndValue = "NEW.sys_period_start";
    }

    @Override
    protected void dropTriggers(DdlBuffer buffer, String baseTable) {
        buffer.append("drop trigger ").append(this.updateTriggerName(baseTable)).endOfStatement();
        buffer.append("drop trigger ").append(this.deleteTriggerName(baseTable)).endOfStatement();
    }

    @Override
    protected void createTriggers(DdlWrite writer, MTable table) {
        DbTriggerUpdate update = this.createDbTriggerUpdate(writer, table);
        this.addBeforeUpdate(this.updateTriggerName(update.getBaseTable()), update);
        this.addBeforeDelete(this.deleteTriggerName(update.getBaseTable()), update);
    }

    @Override
    protected void updateHistoryTriggers(DbTriggerUpdate update) {
        this.recreateHistoryView(update);
        DdlBuffer buffer = update.historyTriggerBuffer();
        String baseTable = update.getBaseTable();
        this.dropTriggers(buffer, baseTable);
        this.addBeforeUpdate(this.updateTriggerName(baseTable), update);
        this.addBeforeDelete(this.deleteTriggerName(baseTable), update);
    }

    private void addBeforeUpdate(String triggerName, DbTriggerUpdate update) {
        DdlBuffer apply = update.historyTriggerBuffer();
        this.addTriggerStart(triggerName, update, apply, " before update for each row as ");
        apply.append("    NEW.sys_period_start = greatest(current_timestamp, date_add(OLD.sys_period_start, interval 1 microsecond))").endOfStatement();
        this.appendInsertIntoHistory(apply, update.getHistoryTable(), update.getColumns());
        this.addEndTrigger(apply);
    }

    private void addBeforeDelete(String triggerName, DbTriggerUpdate update) {
        DdlBuffer apply = update.historyTriggerBuffer();
        this.addTriggerStart(triggerName, update, apply, " before delete for each row as");
        this.appendInsertIntoHistory(apply, update.getHistoryTable(), update.getColumns());
        this.addEndTrigger(apply);
    }

    private void addTriggerStart(String triggerName, DbTriggerUpdate update, DdlBuffer apply, String s) {
        apply.append("delimiter $$").newLine().append("create or replace trigger ").append(triggerName).append(" for ").append(update.getBaseTable()).append(s).newLine();
    }

    private void addEndTrigger(DdlBuffer apply) {
        apply.append("end_trigger").endOfStatement().append("$$").newLine().newLine();
    }
}

