/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.DbPlatformType;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlAlterTable;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.BaseAlterTableWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.BaseDdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlHelp;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.HanaHistoryDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.migration.AlterColumn;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractHanaDdl
extends PlatformDdl {
    private static final Pattern ARRAY_PATTERN = Pattern.compile("(\\w+)\\s*\\[\\s*\\]\\s*(\\(\\d+\\))?", 2);

    public AbstractHanaDdl(DatabasePlatform platform) {
        super(platform);
        this.addColumn = "add";
        this.alterColumn = "alter";
        this.columnDropDefault = "default null";
        this.columnSetDefault = "default";
        this.columnSetNotnull = "not null";
        this.columnSetNull = " null";
        this.dropColumn = "drop";
        this.dropConstraintIfExists = "drop constraint ";
        this.dropIndexIfExists = "drop index ";
        this.dropSequenceIfExists = "drop sequence ";
        this.dropTableCascade = " cascade";
        this.dropTableIfExists = "drop table ";
        this.fallbackArrayType = "nvarchar(1000)";
        this.historyDdl = new HanaHistoryDdl();
        this.identitySuffix = " generated by default as identity";
    }

    @Override
    public void alterColumn(DdlWrite writer, AlterColumn alter) {
        String defaultValueClause;
        String notnullClause;
        String tableName = alter.getTableName();
        String columnName = alter.getColumnName();
        String currentType = alter.getCurrentType();
        String type = alter.getType() != null ? alter.getType() : currentType;
        type = this.convert(type);
        currentType = this.convert(currentType);
        boolean notnull = alter.isNotnull() != null ? alter.isNotnull().booleanValue() : Boolean.TRUE.equals(alter.isCurrentNotnull());
        String string = notnullClause = notnull ? " not null" : "";
        String defaultValue = DdlHelp.isDropDefault(alter.getDefaultValue()) ? "null" : (alter.getDefaultValue() != null ? alter.getDefaultValue() : alter.getCurrentDefaultValue());
        String string2 = defaultValueClause = defaultValue == null || defaultValue.isEmpty() ? "" : " default " + defaultValue;
        if (!this.isConvertible(currentType, type)) {
            if (this.isNumberType(currentType)) {
                this.alterTable(writer, tableName).append(this.alterColumn, columnName).append("decimal").append(notnullClause);
            } else if (this.isStringType(currentType)) {
                this.alterTable(writer, tableName).append(this.alterColumn, columnName).append("nclob").append(notnullClause);
            }
        }
        this.alterTable(writer, tableName).append(this.alterColumn, columnName).append(type).append(defaultValueClause).append(notnullClause);
    }

    @Override
    protected String convertArrayType(String logicalArrayType) {
        Matcher matcher = ARRAY_PATTERN.matcher(logicalArrayType);
        if (matcher.matches()) {
            return this.convert(matcher.group(1)) + " array" + (matcher.group(2) == null ? "" : matcher.group(2));
        }
        return this.fallbackArrayType;
    }

    @Override
    public String alterTableAddUniqueConstraint(String tableName, String uqName, String[] columns, String[] nullableColumns) {
        if (nullableColumns == null || nullableColumns.length == 0) {
            return super.alterTableAddUniqueConstraint(tableName, uqName, columns, nullableColumns);
        }
        return "-- cannot create unique index \"" + uqName + "\" on table \"" + tableName + "\" with nullable columns";
    }

    @Override
    public String alterTableDropUniqueConstraint(String tableName, String uniqueConstraintName) {
        BaseDdlBuffer buffer = new BaseDdlBuffer();
        buffer.append("delimiter $$").newLine();
        buffer.append("do").newLine();
        buffer.append("begin").newLine();
        buffer.append("declare exit handler for sql_error_code 397 begin end").endOfStatement();
        buffer.append("exec 'alter table ").append(tableName).append(" ").append(this.dropUniqueConstraint).append(" ").append(this.maxConstraintName(uniqueConstraintName)).append("'").endOfStatement();
        buffer.append("end").endOfStatement();
        buffer.append("$$");
        return buffer.getBuffer();
    }

    @Override
    public String alterTableDropConstraint(String tableName, String constraintName) {
        return this.alterTableDropUniqueConstraint(tableName, constraintName);
    }

    @Override
    public void alterTableDropColumn(DdlWrite writer, String tableName, String columnName) {
        this.alterTable(writer, tableName).raw("CALL usp_ebean_drop_column('").append(tableName).append("', '").append(columnName).append("')");
    }

    private boolean isConvertible(String sourceType, String targetType) {
        DbPlatformType dbPlatformTargetType;
        if (Objects.equals(sourceType, targetType)) {
            return true;
        }
        if (sourceType == null || targetType == null) {
            return true;
        }
        if ("bigint".equals(sourceType) ? "integer".equals(targetType) || "smallint".equals(targetType) || "tinyint".equals(targetType) : ("integer".equals(sourceType) ? "smallint".equals(targetType) || "tinyint".equals(targetType) : ("smallint".equals(sourceType) ? "tinyint".equals(targetType) : "double".equals(sourceType) && "real".equals(targetType)))) {
            return false;
        }
        DbPlatformType dbPlatformSourceType = DbPlatformType.parse((String)sourceType);
        return !("float".equals(dbPlatformSourceType.getName()) ? "real".equals(targetType) : ("varchar".equals(dbPlatformSourceType.getName()) || "nvarchar".equals(dbPlatformSourceType.getName()) ? ("varchar".equals((dbPlatformTargetType = DbPlatformType.parse((String)targetType)).getName()) || "nvarchar".equals(dbPlatformTargetType.getName())) && dbPlatformSourceType.getDefaultLength() > dbPlatformTargetType.getDefaultLength() : "decimal".equals(dbPlatformSourceType.getName()) && "decimal".equals((dbPlatformTargetType = DbPlatformType.parse((String)targetType)).getName()) && (dbPlatformSourceType.getDefaultLength() > dbPlatformTargetType.getDefaultLength() || dbPlatformSourceType.getDefaultScale() > dbPlatformTargetType.getDefaultScale())));
    }

    private boolean isNumberType(String type) {
        return type != null && ("bigint".equals(type) || "integer".equals(type) || "smallint".equals(type) || "tinyint".equals(type) || type.startsWith("float") || "real".equals(type) || "double".equals(type) || type.startsWith("decimal"));
    }

    private boolean isStringType(String type) {
        return type != null && (type.startsWith("varchar") || type.startsWith("nvarchar") || "clob".equals(type) || "nclob".equals(type));
    }

    @Override
    protected DdlAlterTable alterTable(DdlWrite writer, String tableName) {
        return writer.applyAlterTable(tableName, HanaAlterTableWrite::new);
    }

    private static class HanaAlterTableWrite
    extends BaseAlterTableWrite {
        public HanaAlterTableWrite(String tableName) {
            super(tableName);
        }

        @Override
        protected List<BaseAlterTableWrite.AlterCmd> postProcessCommands(List<BaseAlterTableWrite.AlterCmd> cmds) {
            ArrayList<BaseAlterTableWrite.AlterCmd> newCmds = new ArrayList<BaseAlterTableWrite.AlterCmd>();
            LinkedHashMap<String, List<BaseAlterTableWrite.AlterCmd>> batches = new LinkedHashMap<String, List<BaseAlterTableWrite.AlterCmd>>();
            HashSet<String> columns = new HashSet<String>();
            block8: for (BaseAlterTableWrite.AlterCmd cmd : cmds) {
                switch (cmd.getOperation()) {
                    case "add": 
                    case "alter": 
                    case "drop": {
                        if (cmd.getColumn() != null && !columns.add(cmd.getColumn())) {
                            this.flushBatches(newCmds, batches);
                            columns.clear();
                        }
                        batches.computeIfAbsent(cmd.getOperation(), k -> new ArrayList()).add(cmd);
                        continue block8;
                    }
                }
                this.flushBatches(newCmds, batches);
                columns.clear();
                newCmds.add(cmd);
            }
            this.flushBatches(newCmds, batches);
            return newCmds;
        }

        private void flushBatches(List<BaseAlterTableWrite.AlterCmd> newCmds, Map<String, List<BaseAlterTableWrite.AlterCmd>> batches) {
            for (Map.Entry<String, List<BaseAlterTableWrite.AlterCmd>> entry : batches.entrySet()) {
                BaseAlterTableWrite.AlterCmd raw = this.newRawCommand("alter table ").append(this.tableName()).append(" ").append(entry.getKey()).append(" (");
                List<BaseAlterTableWrite.AlterCmd> cmds = entry.getValue();
                for (int i = 0; i < cmds.size(); ++i) {
                    BaseAlterTableWrite.AlterCmd cmd = cmds.get(i);
                    if (i > 0) {
                        raw.append(",\n   ");
                    }
                    raw.append(cmd.getColumn());
                    if (cmd.getAlternation().isEmpty()) continue;
                    raw.append(" ").append(cmd.getAlternation());
                }
                raw.append(")");
                newCmds.add(raw);
            }
            batches.clear();
        }
    }
}

