/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.config.DatabaseConfig;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlAlterTable;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformHistoryDdl;
import io.ebeaninternal.dbmigration.migration.AddHistoryTable;
import io.ebeaninternal.dbmigration.migration.DropHistoryTable;
import io.ebeaninternal.dbmigration.model.MColumn;
import io.ebeaninternal.dbmigration.model.MTable;
import java.util.Collection;

public class Db2HistoryDdl
implements PlatformHistoryDdl {
    private String systemPeriodStart;
    private String systemPeriodEnd;
    private String transactionId;
    private PlatformDdl platformDdl;
    private String historySuffix;

    @Override
    public void configure(DatabaseConfig config, PlatformDdl platformDdl) {
        this.systemPeriodStart = config.getAsOfSysPeriod() + "_start";
        this.systemPeriodEnd = config.getAsOfSysPeriod() + "_end";
        this.transactionId = config.getAsOfSysPeriod() + "_txn";
        this.platformDdl = platformDdl;
        this.historySuffix = config.getHistoryTableSuffix();
    }

    @Override
    public void createWithHistory(DdlWrite writer, MTable table) {
        String tableName = table.getName();
        String historyTableName = tableName + this.historySuffix;
        DdlBuffer apply = writer.applyPostAlter();
        apply.append(this.platformDdl.getCreateTableCommandPrefix()).append(" ").append(historyTableName).append(" (").newLine();
        Collection<MColumn> cols = table.allColumns();
        for (MColumn column : cols) {
            if (column.isDraftOnly()) continue;
            this.writeColumnDefinition(apply, column.getName(), column.getType(), column.isNotnull() || column.isPrimaryKey());
            apply.append(",").newLine();
        }
        this.writeColumnDefinition(apply, this.systemPeriodStart, "timestamp(12)", true);
        apply.append(",").newLine();
        this.writeColumnDefinition(apply, this.systemPeriodEnd, "timestamp(12)", true);
        apply.append(",").newLine();
        this.writeColumnDefinition(apply, this.transactionId, "timestamp(12)", false);
        apply.newLine().append(")").endOfStatement();
        this.addSysPeriodColumns(writer, tableName);
        this.enableSystemVersioning(apply, tableName);
        this.platformDdl.alterTable(writer, tableName).setHistoryHandled();
        this.disableSystemVersioning(writer.dropAll(), tableName);
        writer.dropAll().append("drop table ").append(historyTableName).endOfStatement();
    }

    void addSysPeriodColumns(DdlWrite writer, String baseTable) {
        this.platformDdl.alterTableAddColumn(writer, baseTable, this.systemPeriodStart, "timestamp(12) not null generated always as row begin", null);
        this.platformDdl.alterTableAddColumn(writer, baseTable, this.systemPeriodEnd, "timestamp(12) not null generated always as row end", null);
        this.platformDdl.alterTableAddColumn(writer, baseTable, this.transactionId, "timestamp(12) generated always as transaction start id", null);
        this.platformDdl.alterTable(writer, baseTable).append("add period system_time", null).append("(").append(this.systemPeriodStart).append(",").append(this.systemPeriodEnd).append(")");
    }

    @Override
    public void dropHistoryTable(DdlWrite writer, DropHistoryTable dropHistoryTable) {
        this.dropHistoryTable(writer, dropHistoryTable.getBaseTable(), dropHistoryTable.getBaseTable() + this.historySuffix);
    }

    protected void dropHistoryTable(DdlWrite writer, String baseTable, String historyTable) {
        this.disableSystemVersioning(writer.apply(), baseTable);
        writer.apply().append("alter table ").append(baseTable).append(" drop period system_time").endOfStatement();
        this.platformDdl.alterTableDropColumn(writer, baseTable, this.systemPeriodStart);
        this.platformDdl.alterTableDropColumn(writer, baseTable, this.systemPeriodEnd);
        this.platformDdl.alterTableDropColumn(writer, baseTable, this.transactionId);
        writer.applyPostAlter().append("drop table ").append(historyTable).endOfStatement();
    }

    @Override
    public void addHistoryTable(DdlWrite writer, AddHistoryTable addHistoryTable) {
        MTable table = writer.getTable(addHistoryTable.getBaseTable());
        if (table == null) {
            throw new IllegalStateException("MTable " + addHistoryTable.getBaseTable() + " not found in writer? (required for history DDL)");
        }
        this.createWithHistory(writer, table);
    }

    @Override
    public boolean alterHistoryTables() {
        return true;
    }

    @Override
    public void updateTriggers(DdlWrite writer, String tableName) {
        DdlAlterTable alter = this.platformDdl.alterTable(writer, tableName);
        MTable table = writer.getTable(tableName);
        if (table.isWithHistory() && !alter.isHistoryHandled()) {
            this.disableSystemVersioning(writer.apply(), tableName);
            this.enableSystemVersioning(writer.applyPostAlter(), tableName);
            alter.setHistoryHandled();
        }
    }

    protected void writeColumnDefinition(DdlBuffer buffer, String columnName, String type, boolean isNotNull) {
        String platformType = this.platformDdl.convert(type);
        buffer.append(" ").append(this.platformDdl.lowerColumnName(columnName));
        buffer.append(" ").append(platformType);
        if (isNotNull) {
            buffer.append(" not null");
        }
    }

    public void disableSystemVersioning(DdlBuffer apply, String tableName) {
        apply.append("alter table ").append(tableName).append(" drop versioning").endOfStatement();
    }

    public void enableSystemVersioning(DdlBuffer apply, String tableName) {
        apply.append("alter table ").append(tableName).append(" add versioning use history table ").append(tableName).append(this.historySuffix).endOfStatement();
    }
}

