/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.config.DatabaseConfig;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlAlterTable;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformHistoryDdl;
import io.ebeaninternal.dbmigration.migration.AddHistoryTable;
import io.ebeaninternal.dbmigration.migration.DropHistoryTable;
import io.ebeaninternal.dbmigration.model.MColumn;
import io.ebeaninternal.dbmigration.model.MTable;
import java.util.Collection;

public class HanaHistoryDdl
implements PlatformHistoryDdl {
    private String systemPeriodStart;
    private String systemPeriodEnd;
    private PlatformDdl platformDdl;
    private String historySuffix;

    @Override
    public void configure(DatabaseConfig config, PlatformDdl platformDdl) {
        this.systemPeriodStart = config.getAsOfSysPeriod() + "_start";
        this.systemPeriodEnd = config.getAsOfSysPeriod() + "_end";
        this.platformDdl = platformDdl;
        this.historySuffix = config.getHistoryTableSuffix();
    }

    @Override
    public void createWithHistory(DdlWrite writer, MTable table) {
        String tableName = table.getName();
        String historyTableName = tableName + this.historySuffix;
        DdlBuffer apply = writer.applyPostAlter();
        apply.append(this.platformDdl.getCreateTableCommandPrefix()).append(" ").append(historyTableName).append(" (").newLine();
        Collection<MColumn> cols = table.allColumns();
        for (MColumn column : cols) {
            if (column.isDraftOnly()) continue;
            this.writeColumnDefinition(apply, column.getName(), column.getType(), column.getDefaultValue(), column.isNotnull(), column.isIdentity() ? this.platformDdl.identitySuffix : null);
            apply.append(",").newLine();
        }
        this.writeColumnDefinition(apply, this.systemPeriodStart, "TIMESTAMP", null, false, null);
        apply.append(",").newLine();
        this.writeColumnDefinition(apply, this.systemPeriodEnd, "TIMESTAMP", null, false, null);
        apply.newLine().append(")").endOfStatement();
        apply.append("alter table ").append(tableName).append(" add (").newLine();
        apply.append("    ").append(this.systemPeriodStart).append(" TIMESTAMP NOT NULL GENERATED ALWAYS AS ROW START, ").newLine();
        apply.append("    ").append(this.systemPeriodEnd).append(" TIMESTAMP NOT NULL GENERATED ALWAYS AS ROW END").newLine();
        apply.append(")").endOfStatement();
        apply.append("alter table ").append(tableName).append(" add period for system_time(").append(this.systemPeriodStart).append(",").append(this.systemPeriodEnd).append(")").endOfStatement();
        this.enableSystemVersioning(apply, tableName, true);
        this.platformDdl.alterTable(writer, tableName).setHistoryHandled();
        this.dropHistoryTable(writer.dropAll(), tableName, historyTableName);
    }

    @Override
    public void dropHistoryTable(DdlWrite writer, DropHistoryTable dropHistoryTable) {
        this.dropHistoryTable(writer.applyDropDependencies(), dropHistoryTable.getBaseTable(), dropHistoryTable.getBaseTable() + this.historySuffix);
    }

    protected void dropHistoryTable(DdlBuffer apply, String baseTable, String historyTable) {
        this.disableSystemVersioning(apply, baseTable);
        apply.append("alter table ").append(baseTable).append(" drop period for system_time").endOfStatement();
        apply.append("alter table ").append(baseTable).append(" drop (").append(this.systemPeriodStart).append(",").append(this.systemPeriodEnd).append(")").endOfStatement();
        apply.append("drop table ").append(historyTable).append(" cascade").endOfStatement();
    }

    @Override
    public void addHistoryTable(DdlWrite writer, AddHistoryTable addHistoryTable) {
        MTable table = writer.getTable(addHistoryTable.getBaseTable());
        if (table == null) {
            throw new IllegalStateException("MTable " + addHistoryTable.getBaseTable() + " not found in writer? (required for history DDL)");
        }
        this.createWithHistory(writer, table);
    }

    @Override
    public boolean alterHistoryTables() {
        return true;
    }

    @Override
    public void updateTriggers(DdlWrite writer, String tableName) {
        DdlAlterTable alter = this.platformDdl.alterTable(writer, tableName);
        MTable table = writer.getTable(tableName);
        if (table.isWithHistory() && !alter.isHistoryHandled()) {
            this.disableSystemVersioning(writer.apply(), tableName);
            this.enableSystemVersioning(writer.applyPostAlter(), tableName, false);
            alter.setHistoryHandled();
        }
    }

    protected void writeColumnDefinition(DdlBuffer buffer, String columnName, String type, String defaultValue, boolean isNotNull, String generated) {
        String platformType = this.platformDdl.convert(type);
        buffer.append(" ").append(this.platformDdl.lowerColumnName(columnName));
        buffer.append(" ").append(platformType);
        if (defaultValue != null) {
            buffer.append(" default ").append(defaultValue);
        }
        if (isNotNull) {
            buffer.append(" not null");
        }
        if (generated != null) {
            buffer.append(" ").append(generated);
        }
    }

    public void disableSystemVersioning(DdlBuffer apply, String tableName) {
        apply.append("alter table ").append(tableName).append(" drop system versioning").endOfStatement();
    }

    public void enableSystemVersioning(DdlBuffer apply, String tableName, boolean validated) {
        apply.append("alter table ").append(tableName).append(" add system versioning history table ").append(tableName).append(this.historySuffix);
        if (!validated) {
            apply.append(" not validated");
        }
        apply.endOfStatement();
    }
}

