/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.config.DatabaseConfig;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlAlterTable;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformHistoryDdl;
import io.ebeaninternal.dbmigration.migration.AddHistoryTable;
import io.ebeaninternal.dbmigration.migration.AlterColumn;
import io.ebeaninternal.dbmigration.migration.DropHistoryTable;
import io.ebeaninternal.dbmigration.model.MTable;

public class SqlServerHistoryDdl
implements PlatformHistoryDdl {
    private String systemPeriodStart;
    private String systemPeriodEnd;
    private PlatformDdl platformDdl;

    @Override
    public void configure(DatabaseConfig config, PlatformDdl platformDdl) {
        this.systemPeriodStart = config.getAsOfSysPeriod() + "From";
        this.systemPeriodEnd = config.getAsOfSysPeriod() + "To";
        this.platformDdl = platformDdl;
    }

    @Override
    public void createWithHistory(DdlWrite writer, MTable table) {
        String baseTable = table.getName();
        this.enableSystemVersioning(writer, baseTable);
    }

    String getHistoryTable(String baseTable) {
        String historyTable = baseTable + "_history";
        if (baseTable.startsWith("[")) {
            historyTable = historyTable.replace("]", "") + "]";
        }
        if (historyTable.indexOf(46) == -1) {
            historyTable = "dbo." + historyTable;
        }
        return historyTable;
    }

    private void enableSystemVersioning(DdlWrite writer, String baseTable) {
        DdlBuffer apply = writer.applyPostAlter();
        apply.append("alter table ").append(baseTable).newLine().append("    add ").append(this.systemPeriodStart).append(" datetime2 GENERATED ALWAYS AS ROW START NOT NULL DEFAULT SYSUTCDATETIME(),").newLine().append("        ").append(this.systemPeriodEnd).append("   datetime2 GENERATED ALWAYS AS ROW END   NOT NULL DEFAULT '9999-12-31T23:59:59.9999999',").newLine().append("period for system_time (").append(this.systemPeriodStart).append(", ").append(this.systemPeriodEnd).append(")").endOfStatement();
        apply.append("alter table ").append(baseTable).append(" set (system_versioning = on (history_table=").append(this.getHistoryTable(baseTable)).append("))").endOfStatement();
        DdlBuffer drop = writer.dropAll();
        drop.append("IF OBJECT_ID('").append(baseTable).append("', 'U') IS NOT NULL alter table ").append(baseTable).append(" set (system_versioning = off)").endOfStatement();
        drop.append("IF OBJECT_ID('").append(baseTable).append("_history', 'U') IS NOT NULL drop table ").append(baseTable).append("_history").endOfStatement();
    }

    @Override
    public void dropHistoryTable(DdlWrite writer, DropHistoryTable dropHistoryTable) {
        String baseTable = dropHistoryTable.getBaseTable();
        AlterColumn alter = new AlterColumn();
        alter.setTableName(baseTable);
        alter.setDefaultValue("DROP DEFAULT");
        alter.setColumnName(this.systemPeriodStart);
        this.platformDdl.alterColumn(writer, alter);
        alter.setColumnName(this.systemPeriodEnd);
        this.platformDdl.alterColumn(writer, alter);
        DdlBuffer apply = writer.apply();
        apply.append("-- dropping history support for ").append(baseTable).endOfStatement();
        apply.append("alter table ").append(baseTable).append(" set (system_versioning = off)").endOfStatement();
        apply.append("alter table ").append(baseTable).append(" drop period for system_time").endOfStatement();
        apply.end();
        this.platformDdl.alterTableDropColumn(writer, baseTable, this.systemPeriodStart);
        this.platformDdl.alterTableDropColumn(writer, baseTable, this.systemPeriodEnd);
        writer.applyPostAlter().appendStatement(this.platformDdl.dropTable(baseTable + "_history"));
    }

    @Override
    public void addHistoryTable(DdlWrite writer, AddHistoryTable addHistoryTable) {
        String baseTable = addHistoryTable.getBaseTable();
        this.enableSystemVersioning(writer, baseTable);
    }

    @Override
    public void updateTriggers(DdlWrite writer, String tableName) {
        DdlAlterTable alter = this.platformDdl.alterTable(writer, tableName);
        writer.getTable(tableName);
        if (!alter.isHistoryHandled()) {
            DdlBuffer apply = writer.apply();
            apply.append("-- alter table ").append(tableName).append(" set (system_versioning = off (history_table=").append(this.getHistoryTable(tableName)).append("))").endOfStatement();
            apply.append("-- history migration goes here").newLine();
            apply.append("-- alter table ").append(tableName).append(" set (system_versioning = on (history_table=").append(this.getHistoryTable(tableName)).append("))").endOfStatement();
        }
        alter.setHistoryHandled();
    }
}

