/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration;

import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlOptions;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.BaseDdlBuffer;
import io.ebeaninternal.dbmigration.model.MConfiguration;
import io.ebeaninternal.dbmigration.model.MTable;
import io.ebeaninternal.dbmigration.model.ModelContainer;

public class DdlWrite {
    private final ModelContainer currentModel;
    private final DdlBuffer applyDropDependencies;
    private final DdlBuffer apply;
    private final DdlBuffer applyForeignKeys;
    private final DdlBuffer applyHistoryView;
    private final DdlBuffer applyHistoryTrigger;
    private final DdlBuffer dropAllForeignKeys;
    private final DdlBuffer dropAll;
    private final DdlOptions options;

    public DdlWrite() {
        this(new MConfiguration(), new ModelContainer(), new DdlOptions());
    }

    public DdlWrite(MConfiguration configuration, ModelContainer currentModel, DdlOptions options) {
        this.currentModel = currentModel;
        this.applyDropDependencies = new BaseDdlBuffer(configuration);
        this.apply = new BaseDdlBuffer(configuration);
        this.applyForeignKeys = new BaseDdlBuffer(configuration);
        this.applyHistoryView = new BaseDdlBuffer(configuration);
        this.applyHistoryTrigger = new BaseDdlBuffer(configuration);
        this.dropAllForeignKeys = new BaseDdlBuffer(configuration);
        this.dropAll = new BaseDdlBuffer(configuration);
        this.options = options;
    }

    public DdlOptions getOptions() {
        return this.options;
    }

    public MTable getTable(String tableName) {
        return this.currentModel.getTable(tableName);
    }

    public boolean isApplyEmpty() {
        return this.apply.getBuffer().isEmpty() && this.applyForeignKeys.getBuffer().isEmpty() && this.applyHistoryView.getBuffer().isEmpty() && this.applyHistoryTrigger.getBuffer().isEmpty() && this.applyDropDependencies.getBuffer().isEmpty();
    }

    public DdlBuffer apply() {
        return this.apply;
    }

    public DdlBuffer applyDropDependencies() {
        return this.applyDropDependencies;
    }

    public DdlBuffer applyForeignKeys() {
        return this.applyForeignKeys;
    }

    public DdlBuffer applyHistoryView() {
        return this.applyHistoryView;
    }

    public DdlBuffer applyHistoryTrigger() {
        return this.applyHistoryTrigger;
    }

    public DdlBuffer dropAllForeignKeys() {
        return this.dropAllForeignKeys;
    }

    public DdlBuffer dropAll() {
        return this.dropAll;
    }
}

