/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.model.build;

import io.ebean.annotation.Platform;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.util.IndexSet;
import io.ebeaninternal.dbmigration.model.MColumn;
import io.ebeaninternal.dbmigration.model.MCompoundForeignKey;
import io.ebeaninternal.dbmigration.model.MCompoundUniqueConstraint;
import io.ebeaninternal.dbmigration.model.MIndex;
import io.ebeaninternal.dbmigration.model.MTable;
import io.ebeaninternal.dbmigration.model.build.ModelBuildContext;
import io.ebeaninternal.dbmigration.model.build.ModelBuildElementTable;
import io.ebeaninternal.dbmigration.model.build.ModelBuildIntersectionTable;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.IndexDefinition;
import io.ebeaninternal.server.deploy.InheritInfo;
import io.ebeaninternal.server.deploy.PropertyForeignKey;
import io.ebeaninternal.server.deploy.TableJoin;
import io.ebeaninternal.server.deploy.TableJoinColumn;
import io.ebeaninternal.server.deploy.id.ImportedId;
import io.ebeaninternal.server.deploy.visitor.BaseTablePropertyVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;

public class ModelBuildPropertyVisitor
extends BaseTablePropertyVisitor {
    protected final ModelBuildContext ctx;
    private final MTable table;
    private final BeanDescriptor<?> beanDescriptor;
    private final IndexSet indexSet = new IndexSet();
    private MColumn lastColumn;
    private int countForeignKey;
    private int countIndex;
    private int countUnique;
    private int countCheck;

    public ModelBuildPropertyVisitor(ModelBuildContext ctx, MTable table, BeanDescriptor<?> beanDescriptor) {
        this.ctx = ctx;
        this.table = table;
        this.beanDescriptor = beanDescriptor;
        this.addIndexes(beanDescriptor.getIndexDefinitions());
    }

    private void addIndexes(IndexDefinition[] indexes) {
        if (indexes != null) {
            for (IndexDefinition index : indexes) {
                String[] columns = index.getColumns();
                this.indexSet.add(columns);
                if (index.isUniqueConstraint()) {
                    this.table.addUniqueConstraint(this.createMUniqueConstraint(index, columns));
                    continue;
                }
                this.ctx.addIndex(this.createMIndex(this.indexName(index), this.table.getName(), index));
            }
        }
    }

    private MCompoundUniqueConstraint createMUniqueConstraint(IndexDefinition index, String[] columns) {
        return new MCompoundUniqueConstraint(columns, false, this.uniqueConstraintName(index), this.platforms(index.getPlatforms()));
    }

    private String uniqueConstraintName(IndexDefinition index) {
        String uqName = index.getName();
        if (uqName == null || uqName.trim().isEmpty()) {
            return this.uniqueConstraintName(index.getColumns());
        }
        return uqName;
    }

    private String indexName(IndexDefinition index) {
        String idxName = index.getName();
        if (idxName == null || idxName.trim().isEmpty()) {
            idxName = this.indexName(index.getColumns());
        }
        return idxName;
    }

    private MIndex createMIndex(String indexName, String tableName, IndexDefinition index) {
        return new MIndex(indexName, tableName, index.getColumns(), this.platforms(index.getPlatforms()), index.isUnique(), index.isConcurrent(), index.getDefinition());
    }

    private String platforms(Platform[] platforms) {
        if (platforms == null || platforms.length == 0) {
            return null;
        }
        StringJoiner joiner = new StringJoiner(",");
        for (Platform platform : platforms) {
            joiner.add(platform.name());
        }
        return joiner.toString();
    }

    public void visitEnd() {
        this.table.setPkName(this.primaryKeyName());
        for (MColumn column : this.table.allColumns()) {
            if (!this.hasValue(column.getForeignKeyIndex()) || !this.indexSet.contains(column.getName())) continue;
            column.setForeignKeyIndex(null);
        }
        for (MCompoundForeignKey compoundKey : this.table.getCompoundKeys()) {
            if (!this.indexSet.contains(compoundKey.getColumns())) continue;
            compoundKey.setIndexName(null);
        }
        this.addDraftTable();
        this.table.updateCompoundIndices();
    }

    private void addDraftTable() {
        if (this.beanDescriptor.isDraftable() || this.beanDescriptor.isDraftableElement()) {
            this.ctx.createDraft(this.table, !this.beanDescriptor.isDraftableElement());
        }
    }

    public void visitMany(BeanPropertyAssocMany<?> p) {
        if (p.hasJoinTable() && p.getMappedBy() == null) {
            MTable intersectionTable = new ModelBuildIntersectionTable(this.ctx, p).build();
            if (p.isO2mJoinTable()) {
                intersectionTable.clearForeignKeyIndexes();
                Collection<MColumn> cols = intersectionTable.allColumns();
                if (cols.size() == 2) {
                    MColumn col = new ArrayList<MColumn>(cols).get(1);
                    col.setUnique(this.uniqueConstraintName(col.getName()));
                }
            }
        } else if (p.isElementCollection()) {
            ModelBuildElementTable.build(this.ctx, p);
        }
    }

    public void visitEmbeddedScalar(BeanProperty p, BeanPropertyAssocOne<?> embedded) {
        if (p instanceof BeanPropertyAssocOne) {
            this.visitOneImported((BeanPropertyAssocOne)p);
        } else {
            this.visitScalar(p);
        }
        if (embedded.isId()) {
            this.lastColumn.setPrimaryKey(true);
        }
    }

    public void visitOneImported(BeanPropertyAssocOne<?> p) {
        TableJoinColumn[] columns = p.getTableJoin().columns();
        if (columns.length == 0) {
            throw new RuntimeException("No join columns for " + p.getFullBeanName());
        }
        ImportedId importedId = p.getImportedId();
        ArrayList<MColumn> modelColumns = new ArrayList<MColumn>(columns.length);
        MCompoundForeignKey compoundKey = null;
        if (columns.length > 1) {
            String string = p.getTargetDescriptor().getBaseTable();
            String fkName = this.foreignKeyConstraintName(p.getName());
            String fkIndex = this.foreignKeyIndexName(p.getName());
            compoundKey = new MCompoundForeignKey(fkName, string, fkIndex);
            this.table.addForeignKey(compoundKey);
        }
        for (TableJoinColumn column : columns) {
            String dbCol = column.getLocalDbColumn();
            BeanProperty importedProperty = importedId.findMatchImport(dbCol);
            if (importedProperty == null) {
                throw new RuntimeException("Imported BeanProperty not found?");
            }
            String columnDefn = this.ctx.getColumnDefn(importedProperty, true);
            String refColumn = importedProperty.getDbColumn();
            MColumn col = this.table.addColumn(dbCol, columnDefn, !p.isNullable());
            col.setDbMigrationInfos(p.getDbMigrationInfos());
            col.setDefaultValue(p.getDbColumnDefault());
            if (columns.length == 1) {
                if (p.hasForeignKeyConstraint() && !importedProperty.getBeanDescriptor().suppressForeignKey()) {
                    PropertyForeignKey foreignKey;
                    String refTable = importedProperty.getBeanDescriptor().getBaseTable();
                    if (refTable == null) {
                        refTable = p.getTargetDescriptor().getBaseTable();
                    }
                    col.setReferences(refTable + "." + refColumn);
                    col.setForeignKeyName(this.foreignKeyConstraintName(col.getName()));
                    if (p.hasForeignKeyIndex()) {
                        col.setForeignKeyIndex(this.foreignKeyIndexName(col.getName()));
                    }
                    if ((foreignKey = p.getForeignKey()) != null) {
                        col.setForeignKeyModes(foreignKey.getOnDelete(), foreignKey.getOnUpdate());
                    }
                }
            } else {
                compoundKey.addColumnPair(dbCol, refColumn);
            }
            modelColumns.add(col);
        }
        if (p.isOneToOne()) {
            if (modelColumns.size() == 1) {
                MColumn mColumn = (MColumn)modelColumns.get(0);
                this.indexSetAdd(mColumn.getName());
                mColumn.setUniqueOneToOne(this.uniqueConstraintName(mColumn.getName()));
            } else {
                String[] stringArray = this.indexSetAdd(this.toColumnNames(modelColumns));
                String uqName = this.uniqueConstraintName(p.getName());
                this.table.addUniqueConstraint(new MCompoundUniqueConstraint(stringArray, uqName));
            }
        }
    }

    public void visitScalar(BeanProperty p) {
        Set checkConstraintValues;
        if (p.isSecondaryTable()) {
            this.lastColumn = null;
            return;
        }
        MColumn col = new MColumn(p.getDbColumn(), this.ctx.getColumnDefn(p, false));
        col.setComment(p.getDbComment());
        col.setDraftOnly(p.isDraftOnly());
        col.setHistoryExclude(p.isExcludedFromHistory());
        if (p.isId()) {
            PropertyForeignKey foreignKey;
            TableJoin primaryKeyJoin;
            col.setPrimaryKey(true);
            if (p.getBeanDescriptor().isUseIdGenerator()) {
                col.setIdentity(true);
            }
            if (!((primaryKeyJoin = p.getBeanDescriptor().getPrimaryKeyJoin()) == null || this.table.isPartitioned() || (foreignKey = primaryKeyJoin.getForeignKey()) != null && foreignKey.isNoConstraint())) {
                TableJoinColumn[] columns = primaryKeyJoin.columns();
                col.setReferences(primaryKeyJoin.getTable() + "." + columns[0].getForeignDbColumn());
                col.setForeignKeyName(this.foreignKeyConstraintName(col.getName()));
                if (foreignKey != null) {
                    col.setForeignKeyModes(foreignKey.getOnDelete(), foreignKey.getOnUpdate());
                }
            }
        } else {
            col.setDefaultValue(p.getDbColumnDefault());
            if (!p.isNullable() || p.isDDLNotNull()) {
                col.setNotnull(true);
            }
        }
        col.setDbMigrationInfos(p.getDbMigrationInfos());
        if (p.isUnique() && !p.isId()) {
            col.setUnique(this.uniqueConstraintName(col.getName()));
            this.indexSetAdd(col.getName());
        }
        if ((checkConstraintValues = p.getDbCheckConstraintValues()) != null) {
            if (this.beanDescriptor.hasInheritance()) {
                InheritInfo inheritInfo = this.beanDescriptor.getInheritInfo();
                inheritInfo.appendCheckConstraintValues(p.getName(), checkConstraintValues);
            }
            col.setCheckConstraint(this.buildCheckConstraint(p.getDbColumn(), checkConstraintValues));
            col.setCheckConstraintName(this.checkConstraintName(col.getName()));
        }
        this.lastColumn = col;
        this.table.addColumn(col);
    }

    private String buildCheckConstraint(String dbColumn, Set<String> checkConstraintValues) {
        StringBuilder sb = new StringBuilder();
        sb.append("check ( ").append(dbColumn).append(" in (");
        int count = 0;
        for (String value : checkConstraintValues) {
            if (count++ > 0) {
                sb.append(",");
            }
            sb.append(value);
        }
        sb.append("))");
        return sb.toString();
    }

    private void indexSetAdd(String column) {
        this.indexSet.add(column);
    }

    private String[] indexSetAdd(String[] cols) {
        this.indexSet.add(cols);
        return cols;
    }

    private String[] toColumnNames(List<MColumn> modelColumns) {
        String[] cols = new String[modelColumns.size()];
        for (int i = 0; i < modelColumns.size(); ++i) {
            cols[i] = modelColumns.get(i).getName();
        }
        return cols;
    }

    protected String primaryKeyName() {
        return this.ctx.primaryKeyName(this.table.getName());
    }

    protected String foreignKeyConstraintName(String columnName) {
        return this.ctx.foreignKeyConstraintName(this.table.getName(), columnName, ++this.countForeignKey);
    }

    protected String foreignKeyIndexName(String column) {
        String[] cols = new String[]{column};
        return this.foreignKeyIndexName(cols);
    }

    protected String foreignKeyIndexName(String[] columns) {
        return this.ctx.foreignKeyIndexName(this.table.getName(), columns, ++this.countIndex);
    }

    protected String indexName(String[] columns) {
        return this.ctx.indexName(this.table.getName(), columns, ++this.countIndex);
    }

    protected String uniqueConstraintName(String columnName) {
        return this.ctx.uniqueConstraintName(this.table.getName(), columnName, ++this.countUnique);
    }

    protected String uniqueConstraintName(String[] columnNames) {
        return this.ctx.uniqueConstraintName(this.table.getName(), columnNames, ++this.countUnique);
    }

    protected String checkConstraintName(String columnName) {
        return this.ctx.checkConstraintName(this.table.getName(), columnName, ++this.countCheck);
    }

    private boolean hasValue(String val) {
        return val != null && !val.isEmpty();
    }
}

