/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.model.build;

import io.ebean.config.DbConstraintNaming;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.DbPlatformType;
import io.ebean.config.dbplatform.DbPlatformTypeMapping;
import io.ebean.core.type.ScalarType;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DefaultConstraintMaxLength;
import io.ebeaninternal.dbmigration.model.MColumn;
import io.ebeaninternal.dbmigration.model.MCompoundForeignKey;
import io.ebeaninternal.dbmigration.model.MIndex;
import io.ebeaninternal.dbmigration.model.MTable;
import io.ebeaninternal.dbmigration.model.ModelContainer;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.TableJoin;
import io.ebeaninternal.server.deploy.TableJoinColumn;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ModelBuildContext {
    private final DbPlatformTypeMapping dbTypeMap = DbPlatformTypeMapping.logicalTypes();
    private final ModelContainer model;
    private final DatabasePlatform databasePlatform;
    private final DbConstraintNaming constraintNaming;
    private final DbConstraintNaming.MaxLength maxLength;
    private final boolean platformTypes;

    public ModelBuildContext(ModelContainer model, DatabasePlatform databasePlatform, DbConstraintNaming naming, boolean platformTypes) {
        this.model = model;
        this.databasePlatform = databasePlatform;
        this.constraintNaming = naming;
        this.platformTypes = platformTypes;
        this.maxLength = this.maxLength();
    }

    private DbConstraintNaming.MaxLength maxLength() {
        if (this.constraintNaming.getMaxLength() != null) {
            return this.constraintNaming.getMaxLength();
        }
        return new DefaultConstraintMaxLength(this.databasePlatform.getMaxConstraintNameLength());
    }

    public void adjustDraftReferences() {
        this.model.adjustDraftReferences();
    }

    public String normaliseTable(String baseTable) {
        return this.constraintNaming.normaliseTable(baseTable);
    }

    private String name(String constraintName, int indexCount) {
        return this.databasePlatform.convertQuotedIdentifiers(this.maxLength(constraintName, indexCount));
    }

    private String maxLength(String constraintName, int indexCount) {
        return this.maxLength.maxLength(constraintName, indexCount);
    }

    public String primaryKeyName(String tableName) {
        return this.name(this.constraintNaming.primaryKeyName(tableName), 0);
    }

    public String foreignKeyConstraintName(String tableName, String columnName, int foreignKeyCount) {
        return this.name(this.constraintNaming.foreignKeyConstraintName(tableName, columnName), foreignKeyCount);
    }

    public String foreignKeyIndexName(String tableName, String[] columns, int indexCount) {
        return this.name(this.constraintNaming.foreignKeyIndexName(tableName, columns), indexCount);
    }

    public String foreignKeyIndexName(String tableName, String column, int indexCount) {
        return this.name(this.constraintNaming.foreignKeyIndexName(tableName, column), indexCount);
    }

    public String indexName(String tableName, String column, int indexCount) {
        return this.name(this.constraintNaming.indexName(tableName, column), indexCount);
    }

    public String indexName(String tableName, String[] columns, int indexCount) {
        return this.name(this.constraintNaming.indexName(tableName, columns), indexCount);
    }

    public String uniqueConstraintName(String tableName, String columnName, int indexCount) {
        return this.name(this.constraintNaming.uniqueConstraintName(tableName, columnName), indexCount);
    }

    public String uniqueConstraintName(String tableName, String[] columnNames, int indexCount) {
        return this.name(this.constraintNaming.uniqueConstraintName(tableName, columnNames), indexCount);
    }

    public String checkConstraintName(String tableName, String columnName, int checkCount) {
        return this.name(this.constraintNaming.checkConstraintName(tableName, columnName), checkCount);
    }

    public MTable addTable(MTable table) {
        return this.model.addTable(table);
    }

    public void addTableElementCollection(MTable table) {
        this.model.addTableElementCollection(table);
    }

    public void addIndex(MIndex index) {
        this.model.addIndex(index);
    }

    public DbPlatformTypeMapping getDbTypeMap() {
        return this.dbTypeMap;
    }

    public String getColumnDefn(BeanProperty p, boolean strict) {
        DbPlatformType dbType = this.getDbType(p);
        if (dbType == null) {
            throw new IllegalStateException("Unknown DbType mapping for " + p.getFullBeanName());
        }
        return p.renderDbType(dbType, strict);
    }

    private DbPlatformType getDbType(BeanProperty p) {
        if (p.isDbEncrypted()) {
            return this.dbTypeMap.get(p.getDbEncryptedType());
        }
        if (p.isLocalEncrypted()) {
            ScalarType scalarType = p.getScalarType();
            int jdbcType = scalarType.getJdbcType();
            return this.dbTypeMap.get(jdbcType);
        }
        int dbType = p.getDbType(this.platformTypes);
        if (dbType == 0) {
            throw new RuntimeException("No scalarType defined for " + p.getFullBeanName());
        }
        return this.dbTypeMap.get(dbType);
    }

    public void createDraft(MTable table, boolean draftable) {
        List<MColumn> pkCols;
        MTable draftTable = table.createDraftTable();
        draftTable.setPkName(this.primaryKeyName(draftTable.getName()));
        if (draftable && (pkCols = table.primaryKeyColumns()).size() == 1) {
            MColumn pk = pkCols.get(0);
            pk.setReferences(draftTable.getName() + "." + pk.getName());
            pk.setForeignKeyName(this.foreignKeyConstraintName(table.getName(), pk.getName(), 0));
        }
        int fkCount = 0;
        int ixCount = 0;
        int uqCount = 0;
        Collection<MColumn> cols = draftTable.allColumns();
        for (MColumn col : cols) {
            if (col.getForeignKeyName() != null) {
                col.setForeignKeyName(this.foreignKeyConstraintName(draftTable.getName(), col.getName(), ++fkCount));
                String[] indexCols = new String[]{col.getName()};
                col.setForeignKeyIndex(this.foreignKeyIndexName(draftTable.getName(), indexCols, ++ixCount));
            }
            if (col.getUnique() != null) {
                col.setUnique(this.uniqueConstraintName(draftTable.getName(), col.getName(), ++uqCount));
            }
            if (col.getUniqueOneToOne() == null) continue;
            col.setUniqueOneToOne(this.uniqueConstraintName(draftTable.getName(), col.getName(), ++uqCount));
        }
        this.addTable(draftTable);
    }

    public FkeyBuilder fkeyBuilder(MTable destTable) {
        return new FkeyBuilder(this, destTable);
    }

    public static class FkeyBuilder {
        private final AtomicInteger count = new AtomicInteger();
        private final ModelBuildContext ctx;
        private final MTable destTable;
        private final String tableName;

        FkeyBuilder(ModelBuildContext ctx, MTable destTable) {
            this.ctx = ctx;
            this.destTable = destTable;
            this.tableName = destTable.getName();
        }

        public FkeyBuilder addForeignKey(BeanDescriptor<?> desc, TableJoin tableJoin, boolean direction) {
            String baseTable = this.ctx.normaliseTable(desc.getBaseTable());
            String fkName = this.ctx.foreignKeyConstraintName(this.tableName, baseTable, this.count.incrementAndGet());
            String fkIndex = this.ctx.foreignKeyIndexName(this.tableName, baseTable, this.count.get());
            MCompoundForeignKey foreignKey = new MCompoundForeignKey(fkName, desc.getBaseTable(), fkIndex);
            for (TableJoinColumn column : tableJoin.columns()) {
                String localCol = direction ? column.getForeignDbColumn() : column.getLocalDbColumn();
                String refCol = !direction ? column.getForeignDbColumn() : column.getLocalDbColumn();
                foreignKey.addColumnPair(localCol, refCol);
            }
            this.destTable.addForeignKey(foreignKey);
            return this;
        }
    }
}

