/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.annotation.ConstraintMode;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlIdentity;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;

public class OracleDdl
extends PlatformDdl {
    public OracleDdl(DatabasePlatform platform) {
        super(platform);
        this.dropTableIfExists = "drop table ";
        this.dropSequenceIfExists = "drop sequence ";
        this.dropConstraintIfExists = "drop constraint";
        this.dropIndexIfExists = "drop index ";
        this.dropTableCascade = " cascade constraints purge";
        this.addColumn = "add";
        this.alterColumn = "modify";
        this.columnSetNotnull = "not null";
        this.columnSetNull = "null";
        this.columnSetDefault = "default";
        this.columnDropDefault = "default null";
        this.identitySuffix = " generated by default as identity";
    }

    @Override
    public String alterTableAddUniqueConstraint(String tableName, String uqName, String[] columns, String[] nullableColumns) {
        if (nullableColumns == null || nullableColumns.length == 0) {
            return super.alterTableAddUniqueConstraint(tableName, uqName, columns, nullableColumns);
        }
        return "-- NOT YET IMPLEMENTED: " + super.alterTableAddUniqueConstraint(tableName, uqName, columns, nullableColumns);
    }

    @Override
    public String dropSequence(String sequenceName) {
        return this.ignoreError(-2289, super.dropSequence(sequenceName));
    }

    @Override
    public String alterTableDropConstraint(String tableName, String constraintName) {
        return this.ignoreError(-2443, super.alterTableDropConstraint(tableName, constraintName));
    }

    @Override
    public String alterTableDropUniqueConstraint(String tableName, String uniqueConstraintName) {
        return this.ignoreError(-2443, super.alterTableDropUniqueConstraint(tableName, uniqueConstraintName));
    }

    @Override
    protected void appendForeignKeyOnUpdate(StringBuilder buffer, ConstraintMode mode) {
    }

    @Override
    protected void appendForeignKeyMode(StringBuilder buffer, String onMode, ConstraintMode mode) {
        switch (mode) {
            case SET_NULL: 
            case CASCADE: {
                super.appendForeignKeyMode(buffer, onMode, mode);
            }
        }
    }

    @Override
    public String asIdentityColumn(String columnDefn, DdlIdentity identity) {
        return this.asIdentityStandardOptions(columnDefn, identity);
    }

    private String ignoreError(int errorNr, String statement) {
        StringBuilder sb = new StringBuilder();
        sb.append("delimiter $$\n").append("declare\n").append("  expected_error exception;\n").append("  pragma exception_init(expected_error, ").append(errorNr).append(");\n").append("begin\n").append("  execute immediate '").append(statement).append("';\n").append("exception\n").append("  when expected_error then null;\n").append("end;\n$$");
        return sb.toString();
    }
}

