/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration;

import io.ebeaninternal.dbmigration.ddlgeneration.DdlAlterTable;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlOptions;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.BaseDdlBuffer;
import io.ebeaninternal.dbmigration.model.MConfiguration;
import io.ebeaninternal.dbmigration.model.MTable;
import io.ebeaninternal.dbmigration.model.ModelContainer;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;

public class DdlWrite {
    private final ModelContainer currentModel;
    private final DdlBuffer applyDropDependencies = new BaseDdlBuffer();
    private final DdlBuffer apply = new BaseDdlBuffer();
    private final Map<String, DdlAlterTable> applyAlterTables = new TreeMap<String, DdlAlterTable>();
    private final DdlBuffer applyPostAlter = new BaseDdlBuffer();
    private final DdlBuffer applyForeignKeys = new BaseDdlBuffer();
    private final DdlBuffer dropAllForeignKeys = new BaseDdlBuffer();
    private final DdlBuffer dropAll = new BaseDdlBuffer();
    private final DdlOptions options;

    public DdlWrite() {
        this(new MConfiguration(), new ModelContainer(), new DdlOptions());
    }

    public DdlWrite(MConfiguration configuration, ModelContainer currentModel, DdlOptions options) {
        this.currentModel = currentModel;
        this.options = options;
    }

    public DdlOptions getOptions() {
        return this.options;
    }

    public MTable getTable(String tableName) {
        return this.currentModel.getTable(tableName);
    }

    public boolean isApplyEmpty() {
        return this.apply.getBuffer().isEmpty() && this.applyAlterTables.isEmpty() && this.applyPostAlter.getBuffer().isEmpty() && this.applyForeignKeys.getBuffer().isEmpty() && this.applyDropDependencies.getBuffer().isEmpty();
    }

    public DdlBuffer applyPostAlter() {
        return this.applyPostAlter;
    }

    public DdlBuffer apply() {
        return this.apply;
    }

    public DdlBuffer applyDropDependencies() {
        return this.applyDropDependencies;
    }

    public DdlAlterTable applyAlterTable(String tableName, Function<String, DdlAlterTable> factory) {
        return this.applyAlterTables.computeIfAbsent(tableName, factory);
    }

    public DdlBuffer applyForeignKeys() {
        return this.applyForeignKeys;
    }

    public DdlBuffer dropAllForeignKeys() {
        return this.dropAllForeignKeys;
    }

    public DdlBuffer dropAll() {
        return this.dropAll;
    }

    public void writeApply(Appendable target) throws IOException {
        if (!this.applyDropDependencies.isEmpty()) {
            target.append("-- drop dependencies\n");
            target.append(this.applyDropDependencies.getBuffer());
        }
        if (!this.apply.isEmpty()) {
            target.append("-- apply changes\n");
            target.append(this.apply.getBuffer());
        }
        if (!this.applyAlterTables.isEmpty()) {
            target.append("-- apply alter tables\n");
            for (DdlAlterTable alterTable : this.applyAlterTables.values()) {
                alterTable.write(target);
            }
        }
        if (!this.applyPostAlter.isEmpty()) {
            target.append("-- apply post alter\n");
            target.append(this.applyPostAlter.getBuffer());
        }
        if (!this.applyForeignKeys.isEmpty()) {
            target.append("-- foreign keys and indices\n");
            target.append(this.applyForeignKeys.getBuffer());
        }
    }

    public void writeDropAll(Appendable target) throws IOException {
        if (!this.dropAllForeignKeys.isEmpty()) {
            target.append("-- drop all foreign keys\n");
            target.append(this.dropAllForeignKeys.getBuffer());
        }
        if (!this.dropAll.isEmpty()) {
            target.append("-- drop all\n");
            target.append(this.dropAll.getBuffer());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.writeDropAll(sb);
            this.writeApply(sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }
}

