/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.DatabaseBuilder;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlAlterTable;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DbTableBasedHistoryDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformHistoryDdl;
import io.ebeaninternal.dbmigration.migration.AddHistoryTable;
import io.ebeaninternal.dbmigration.migration.DropHistoryTable;
import io.ebeaninternal.dbmigration.model.MColumn;
import io.ebeaninternal.dbmigration.model.MTable;
import java.util.List;

public abstract class DbTriggerBasedHistoryDdl
extends DbTableBasedHistoryDdl
implements PlatformHistoryDdl {
    protected String sysPeriod;
    protected String sysPeriodStart;
    protected String sysPeriodEnd;
    protected String viewSuffix;
    protected String sysPeriodType = "datetime(6)";
    protected String now = "now(6)";
    protected String sysPeriodEndValue = "now(6)";

    DbTriggerBasedHistoryDdl() {
    }

    @Override
    public void configure(DatabaseBuilder.Settings config, PlatformDdl platformDdl) {
        super.configure(config, platformDdl);
        this.sysPeriod = config.getAsOfSysPeriod();
        this.viewSuffix = config.getAsOfViewSuffix();
        this.sysPeriodStart = this.sysPeriod + "_start";
        this.sysPeriodEnd = this.sysPeriod + "_end";
    }

    @Override
    public void dropHistoryTable(DdlWrite writer, DropHistoryTable dropHistoryTable) {
        String baseTable = dropHistoryTable.getBaseTable();
        this.dropTriggers(writer.applyDropDependencies(), baseTable);
        this.dropWithHistoryView(writer.applyDropDependencies(), baseTable);
        this.dropHistoryTable(writer.applyDropDependencies(), baseTable);
        this.dropSysPeriodColumns(writer, baseTable);
    }

    @Override
    public void addHistoryTable(DdlWrite writer, AddHistoryTable addHistoryTable) {
        String baseTable = addHistoryTable.getBaseTable();
        MTable table = writer.getTable(baseTable);
        if (table == null) {
            throw new IllegalStateException("MTable " + baseTable + " not found in writer? (required for history DDL)");
        }
        this.createWithHistory(writer, table);
    }

    @Override
    public void createWithHistory(DdlWrite writer, MTable table) {
        String baseTable = this.quote(table.getName());
        this.addSysPeriodColumns(writer, baseTable, table.getWhenCreatedColumn());
        this.createHistoryTable(writer.applyPostAlter(), table);
        this.createWithHistoryView(writer.applyPostAlter(), table.getName());
        this.createTriggers(writer.applyPostAlter(), baseTable, this.columnNamesForApply(table));
        writer.applyPostAlter().end();
        this.dropTriggers(writer.dropAll(), baseTable);
        this.dropWithHistoryView(writer.dropAll(), baseTable);
        this.dropHistoryTable(writer.dropAll(), baseTable);
    }

    @Override
    public void updateTriggers(DdlWrite writer, String tableName) {
        DdlAlterTable alter;
        MTable table = writer.getTable(tableName);
        if (table != null && table.isWithHistory() && !(alter = this.platformDdl.alterTable(writer, tableName)).isHistoryHandled()) {
            this.dropTriggers(writer.apply(), tableName);
            this.dropWithHistoryView(writer.apply(), tableName);
            this.createWithHistoryView(writer.applyPostAlter(), tableName);
            this.createTriggers(writer.applyPostAlter(), this.quote(tableName), this.columnNamesForApply(table));
            alter.setHistoryHandled();
        }
    }

    protected abstract void createTriggers(DdlBuffer var1, String var2, List<String> var3);

    protected abstract void dropTriggers(DdlBuffer var1, String var2);

    protected String historyViewName(String baseTableName) {
        return this.normalise(baseTableName, this.viewSuffix);
    }

    protected String procedureName(String baseTableName) {
        return this.normalise(baseTableName, "_history_version");
    }

    protected String triggerName(String baseTableName) {
        return this.normalise(baseTableName, "_history_upd");
    }

    protected String updateTriggerName(String baseTableName) {
        return this.normalise(baseTableName, "_history_upd");
    }

    protected String deleteTriggerName(String baseTableName) {
        return this.normalise(baseTableName, "_history_del");
    }

    protected void addSysPeriodColumns(DdlWrite writer, String baseTableName, String whenCreatedColumn) {
        this.platformDdl.alterTableAddColumn(writer, baseTableName, this.sysPeriodStart, this.sysPeriodType, this.now);
        this.platformDdl.alterTableAddColumn(writer, baseTableName, this.sysPeriodEnd, this.sysPeriodType, null);
        if (whenCreatedColumn != null) {
            writer.applyPostAlter().append("update ").append(baseTableName).append(" set ").append(this.sysPeriodStart).append(" = ").append(whenCreatedColumn).endOfStatement();
        }
    }

    protected void createHistoryTable(DdlBuffer apply, MTable table) {
        this.createHistoryTableAs(apply, table);
        this.createHistoryTableWithPeriod(apply);
        apply.endOfStatement();
    }

    protected void createHistoryTableAs(DdlBuffer apply, MTable table) {
        apply.append(this.platformDdl.getCreateTableCommandPrefix()).append(" ").append(this.historyTableName(table.getName())).append("(").newLine();
        for (MColumn column : table.allColumns()) {
            if (column.isDraftOnly()) continue;
            this.writeColumnDefinition(apply, column.getName(), column.getType());
            apply.append(",").newLine();
        }
        if (table.hasDroppedColumns()) {
            throw new IllegalStateException(table.getName() + " has dropped columns. Please generate drop script before enabling history");
        }
    }

    protected void createHistoryTableWithPeriod(DdlBuffer apply) {
        this.writeColumnDefinition(apply, this.sysPeriodStart, this.sysPeriodType);
        apply.append(",").newLine();
        this.writeColumnDefinition(apply, this.sysPeriodEnd, this.sysPeriodType);
        apply.newLine().append(")");
    }

    protected void writeColumnDefinition(DdlBuffer buffer, String columnName, String type) {
        String platformType = this.platformDdl.convert(type);
        buffer.append("  ");
        buffer.append(this.quote(columnName), 29);
        buffer.append(platformType);
    }

    protected void createWithHistoryView(DdlBuffer apply, String baseTableName) {
        apply.append("create view ").append(this.historyViewName(baseTableName)).append(" as select * from ").append(this.quote(baseTableName)).append(" union all select * from ").append(this.historyTableName(baseTableName)).endOfStatement();
    }

    protected void appendSysPeriodColumns(DdlBuffer apply, String prefix) {
        this.appendColumnName(apply, prefix, this.sysPeriodStart);
        this.appendColumnName(apply, prefix, this.sysPeriodEnd);
    }

    protected void dropWithHistoryView(DdlBuffer apply, String baseTableName) {
        apply.append("drop view ").append(this.historyViewName(baseTableName)).endOfStatement();
    }

    protected void dropHistoryTable(DdlBuffer apply, String baseTableName) {
        apply.append("drop table ").append(this.historyTableName(baseTableName)).endOfStatement().end();
    }

    protected void dropSysPeriodColumns(DdlWrite writer, String baseTableName) {
        this.platformDdl.alterTableDropColumn(writer, baseTableName, this.sysPeriodStart);
        this.platformDdl.alterTableDropColumn(writer, baseTableName, this.sysPeriodEnd);
    }

    protected void appendInsertIntoHistory(DdlBuffer buffer, String baseTable, List<String> columns) {
        buffer.append("    insert into ").append(this.historyTableName(baseTable)).append(" (").append(this.sysPeriodStart).append(",").append(this.sysPeriodEnd).append(",");
        this.appendColumnNames(buffer, columns, "");
        buffer.append(") values (OLD.").append(this.sysPeriodStart).append(", ").append(this.sysPeriodEndValue).append(",");
        this.appendColumnNames(buffer, columns, "OLD.");
        buffer.append(");").newLine();
    }

    void appendColumnNames(DdlBuffer buffer, List<String> columns, String columnPrefix) {
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(columnPrefix);
            buffer.append(this.quote(columns.get(i)));
        }
    }

    void appendColumnName(DdlBuffer buffer, String prefix, String columnName) {
        if (columnName != null) {
            buffer.append(prefix).append(columnName);
        }
    }

    List<String> columnNamesForApply(MTable table) {
        return table.allHistoryColumns(true);
    }
}

