/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DbTriggerBasedHistoryDdl;
import java.util.List;

public class MySqlHistoryDdl
extends DbTriggerBasedHistoryDdl {
    MySqlHistoryDdl() {
    }

    @Override
    protected void dropTriggers(DdlBuffer buffer, String baseTable) {
        buffer.append("drop trigger ").append(this.updateTriggerName(baseTable)).endOfStatement();
        buffer.append("drop trigger ").append(this.deleteTriggerName(baseTable)).endOfStatement();
    }

    @Override
    protected void createTriggers(DdlBuffer buffer, String baseTable, List<String> columnNames) {
        buffer.append("lock tables ").append(baseTable).append(" write").endOfStatement();
        this.addBeforeUpdate(buffer, this.updateTriggerName(baseTable), baseTable, columnNames);
        this.addBeforeDelete(buffer, this.deleteTriggerName(baseTable), baseTable, columnNames);
        buffer.appendStatement("unlock tables");
    }

    private void addBeforeUpdate(DdlBuffer apply, String triggerName, String tableName, List<String> columnNames) {
        apply.append("delimiter $$").newLine().append("create trigger ").append(triggerName).append(" before update on ").append(tableName).append(" for each row begin").newLine();
        this.appendInsertIntoHistory(apply, tableName, columnNames);
        apply.append("    set NEW.").append(this.sysPeriod).append("_start = now(6)").endOfStatement().append("end$$").newLine();
    }

    private void addBeforeDelete(DdlBuffer apply, String triggerName, String tableName, List<String> columnNames) {
        apply.append("delimiter $$").newLine().append("create trigger ").append(triggerName).append(" before delete on ").append(tableName).append(" for each row begin").newLine();
        this.appendInsertIntoHistory(apply, tableName, columnNames);
        apply.append("end$$").newLine();
    }
}

