/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.annotation.ConstraintMode;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlIdentity;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.NuoDbHistoryDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;

public class NuoDbDdl
extends PlatformDdl {
    public NuoDbDdl(DatabasePlatform platform) {
        super(platform);
        this.historyDdl = new NuoDbHistoryDdl();
        this.identitySuffix = " generated by default as identity";
        this.dropConstraintIfExists = "drop constraint";
    }

    @Override
    public String createSequence(String sequenceName, DdlIdentity identity) {
        int cache;
        StringBuilder sb = new StringBuilder("create sequence ");
        sb.append(this.quote(sequenceName));
        int start = identity.getStart();
        if (start > 0) {
            sb.append(' ').append(this.sequenceStartWith).append(' ').append(start);
        }
        if ((cache = identity.getCache()) > 0) {
            sb.append(" quantum size ").append(cache);
        }
        sb.append(';');
        return sb.toString();
    }

    @Override
    public void addTableComment(DdlBuffer apply, String tableName, String tableComment) {
    }

    @Override
    public void addColumnComment(DdlBuffer apply, String table, String column, String comment) {
    }

    @Override
    protected void appendForeignKeyOnUpdate(StringBuilder buffer, ConstraintMode mode) {
    }

    @Override
    protected void appendForeignKeyOnDelete(StringBuilder buffer, ConstraintMode mode) {
        if (mode != ConstraintMode.RESTRICT && mode != ConstraintMode.SET_NULL) {
            super.appendForeignKeyOnDelete(buffer, mode);
        }
    }
}

