/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlIdentity;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.NativeDbArray;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PostgresHistoryDdl;
import io.ebeaninternal.dbmigration.migration.AlterColumn;

public class PostgresDdl
extends PlatformDdl {
    private static final String dropIndexConcurrentlyIfExists = "drop index concurrently if exists ";

    public PostgresDdl(DatabasePlatform platform) {
        super(platform);
        this.historyDdl = new PostgresHistoryDdl();
        this.createSchemaSupport = true;
        this.dropTableCascade = " cascade";
        this.columnSetType = "type ";
        this.alterTableIfExists = "if exists ";
        this.createIndexIfNotExists = "if not exists ";
        this.columnSetNull = "drop not null";
        this.addForeignKeySkipCheck = " not valid";
        this.indexConcurrent = "concurrently ";
    }

    @Override
    public boolean addPartitionColumnToPrimaryKey() {
        return true;
    }

    @Override
    public String setLockTimeout(int lockTimeoutSeconds) {
        return "set lock_timeout = " + lockTimeoutSeconds * 1000;
    }

    @Override
    protected String convertArrayType(String logicalArrayType) {
        return NativeDbArray.logicalToNative(logicalArrayType);
    }

    @Override
    public void addTablePartition(DdlBuffer apply, String partitionMode, String partitionColumn) {
        apply.append(" partition by range (").append(partitionColumn).append(")");
    }

    @Override
    public String dropIndex(String indexName, String tableName, boolean concurrent) {
        return (concurrent ? dropIndexConcurrentlyIfExists : this.dropIndexIfExists) + this.maxConstraintName(indexName);
    }

    @Override
    public String asIdentityColumn(String columnDefn, DdlIdentity identity) {
        return this.asIdentityStandardOptions(columnDefn, identity);
    }

    @Override
    protected void alterColumnType(DdlWrite writer, AlterColumn alter) {
        String type = this.convert(alter.getType());
        this.alterTable(writer, alter.getTableName()).append(this.alterColumn, alter.getColumnName()).append(this.columnSetType).append(type).append(" using ").append(alter.getColumnName()).append("::").append(type);
    }
}

