/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.annotation.Platform;
import io.ebean.config.DatabaseConfig;
import io.ebean.config.DbConstraintNaming;
import io.ebean.config.NamingConvention;
import io.ebean.util.StringHelper;
import io.ebeaninternal.api.PlatformMatch;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlOptions;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.TableDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.BaseTableIdentity;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlHelp;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlIdentity;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformHistoryDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.SplitColumns;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.WriteCreateIndex;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.WriteForeignKey;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.WriteUniqueConstraint;
import io.ebeaninternal.dbmigration.migration.AddColumn;
import io.ebeaninternal.dbmigration.migration.AddHistoryTable;
import io.ebeaninternal.dbmigration.migration.AddTableComment;
import io.ebeaninternal.dbmigration.migration.AddUniqueConstraint;
import io.ebeaninternal.dbmigration.migration.AlterColumn;
import io.ebeaninternal.dbmigration.migration.AlterForeignKey;
import io.ebeaninternal.dbmigration.migration.AlterTable;
import io.ebeaninternal.dbmigration.migration.Column;
import io.ebeaninternal.dbmigration.migration.CreateIndex;
import io.ebeaninternal.dbmigration.migration.CreateSchema;
import io.ebeaninternal.dbmigration.migration.CreateTable;
import io.ebeaninternal.dbmigration.migration.DdlScript;
import io.ebeaninternal.dbmigration.migration.DropColumn;
import io.ebeaninternal.dbmigration.migration.DropHistoryTable;
import io.ebeaninternal.dbmigration.migration.DropIndex;
import io.ebeaninternal.dbmigration.migration.DropTable;
import io.ebeaninternal.dbmigration.migration.ForeignKey;
import io.ebeaninternal.dbmigration.migration.UniqueConstraint;
import io.ebeaninternal.dbmigration.model.MTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BaseTableDdl
implements TableDdl {
    protected final DbConstraintNaming naming;
    protected final NamingConvention namingConvention;
    protected final PlatformDdl platformDdl;
    protected final String historyTableSuffix;
    protected final List<Column> externalUnique = new ArrayList<Column>();
    protected final List<UniqueConstraint> externalCompoundUnique = new ArrayList<UniqueConstraint>();
    private final boolean strictMode;
    private final PlatformHistoryDdl.TableBased tableHistory;

    public BaseTableDdl(DatabaseConfig config, PlatformDdl platformDdl) {
        this.namingConvention = config.getNamingConvention();
        this.naming = config.getConstraintNaming();
        this.historyTableSuffix = config.getHistoryTableSuffix();
        this.platformDdl = platformDdl;
        this.platformDdl.configure(config);
        this.strictMode = config.isDdlStrictMode();
        this.tableHistory = platformDdl.historyDdl instanceof PlatformHistoryDdl.TableBased ? (PlatformHistoryDdl.TableBased)platformDdl.historyDdl : null;
    }

    protected void reset() {
        this.externalUnique.clear();
        this.externalCompoundUnique.clear();
    }

    @Override
    public void generate(DdlWrite writer, CreateSchema createSchema) {
        this.platformDdl.createSchema(writer, createSchema);
    }

    @Override
    public void generate(DdlWrite writer, CreateTable createTable) {
        this.reset();
        String tableName = createTable.getName();
        BaseTableIdentity baseTableIdentity = new BaseTableIdentity(createTable, this.platformDdl, this.namingConvention);
        DdlIdentity identity = baseTableIdentity.identity();
        DdlBuffer apply = writer.apply();
        apply.append(this.platformDdl.getCreateTableCommandPrefix()).append(" ").append(this.platformDdl.quote(tableName)).append(" (");
        this.writeTableColumns(apply, createTable.getColumn(), identity);
        this.writeUniqueConstraints(apply, createTable);
        this.writeCompoundUniqueConstraints(apply, createTable);
        if (baseTableIdentity.hasPrimaryKey()) {
            this.writePrimaryKeyConstraint(apply, createTable.getPkName(), this.toColumnNames(baseTableIdentity.pkColumns()));
        }
        if (this.platformDdl.isInlineForeignKeys()) {
            this.writeInlineForeignKeys(apply, createTable);
        }
        apply.newLine().append(")");
        this.addTableTableSpaces(apply, createTable);
        this.addTableStorageEngine(apply, createTable);
        this.addTableCommentInline(apply, createTable);
        String partitionMode = createTable.getPartitionMode();
        if (partitionMode != null) {
            this.platformDdl.addTablePartition(apply, partitionMode, createTable.getPartitionColumn());
        }
        apply.endOfStatement();
        this.addComments(apply, createTable);
        this.writeUniqueOneToOneConstraints(writer, createTable);
        if (this.isTrue(createTable.isWithHistory())) {
            this.createWithHistory(writer, createTable.getName());
        }
        this.dropTable(writer.dropAll(), tableName);
        if (identity.useSequence()) {
            this.writeSequence(writer, identity);
        }
        apply.end();
        writer.dropAll().end();
        if (!this.platformDdl.isInlineForeignKeys()) {
            this.writeAddForeignKeys(writer, createTable);
        }
    }

    private void addComments(DdlBuffer apply, CreateTable createTable) {
        if (!this.platformDdl.isInlineComments()) {
            String tableComment = createTable.getComment();
            if (this.hasValue(tableComment)) {
                this.platformDdl.addTableComment(apply, createTable.getName(), tableComment);
            }
            for (Column column : createTable.getColumn()) {
                if (StringHelper.isNull((String)column.getComment())) continue;
                this.platformDdl.addColumnComment(apply, createTable.getName(), column.getName(), column.getComment());
            }
        }
    }

    protected void addTableTableSpaces(DdlBuffer apply, CreateTable createTable) {
        String tableSpace = this.platformDdl.extract(createTable.getTablespace());
        if (this.hasValue(tableSpace)) {
            this.platformDdl.addTablespace(apply, tableSpace, this.platformDdl.extract(createTable.getIndexTablespace()), this.platformDdl.extract(createTable.getLobTablespace()));
        }
    }

    private void addTableStorageEngine(DdlBuffer apply, CreateTable createTable) {
        if (this.platformDdl.isIncludeStorageEngine()) {
            this.platformDdl.tableStorageEngine(apply, createTable.getStorageEngine());
        }
    }

    private void addTableCommentInline(DdlBuffer apply, CreateTable createTable) {
        String tableComment;
        if (this.platformDdl.isInlineComments() && !StringHelper.isNull((String)(tableComment = createTable.getComment()))) {
            this.platformDdl.inlineTableComment(apply, tableComment);
        }
    }

    private void writeTableColumns(DdlBuffer apply, List<Column> columns, DdlIdentity identity) {
        this.platformDdl.writeTableColumns(apply, columns, identity);
    }

    protected void writeUniqueOneToOneConstraints(DdlWrite writer, CreateTable createTable) {
        String[] nullableColumns;
        String[] columnNames;
        String uqName;
        String tableName = createTable.getName();
        for (Column col : this.externalUnique) {
            uqName = col.getUniqueOneToOne();
            if (uqName == null) {
                uqName = col.getUnique();
            }
            columnNames = new String[]{col.getName()};
            nullableColumns = Boolean.TRUE.equals(col.isNotnull()) ? null : columnNames;
            writer.applyPostAlter().appendStatement(this.platformDdl.alterTableAddUniqueConstraint(tableName, uqName, columnNames, nullableColumns));
            writer.dropAllForeignKeys().appendStatement(this.platformDdl.dropIndex(uqName, tableName));
        }
        for (UniqueConstraint constraint : this.externalCompoundUnique) {
            uqName = constraint.getName();
            columnNames = SplitColumns.split(constraint.getColumnNames());
            nullableColumns = SplitColumns.split(constraint.getNullableColumns());
            writer.applyPostAlter().appendStatement(this.platformDdl.alterTableAddUniqueConstraint(tableName, uqName, columnNames, nullableColumns));
            writer.dropAllForeignKeys().appendStatement(this.platformDdl.dropIndex(uqName, tableName));
        }
    }

    protected void writeSequence(DdlWrite writer, DdlIdentity identity) {
        String seqName = identity.getSequenceName();
        String createSeq = this.platformDdl.createSequence(seqName, identity);
        if (this.hasValue(createSeq)) {
            writer.apply().append(createSeq).newLine();
            writer.dropAll().appendStatement(this.platformDdl.dropSequence(seqName));
        }
    }

    protected void createWithHistory(DdlWrite writer, String name) {
        MTable table = writer.getTable(name);
        this.platformDdl.createWithHistory(writer, table);
    }

    protected void writeInlineForeignKeys(DdlBuffer buffer, CreateTable createTable) {
        for (Column column : createTable.getColumn()) {
            String references = column.getReferences();
            if (!this.hasValue(references)) continue;
            this.writeInlineForeignKey(buffer, column);
        }
        this.writeInlineCompoundForeignKeys(buffer, createTable);
    }

    protected void writeInlineForeignKey(DdlBuffer buffer, Column column) {
        String fkConstraint = this.platformDdl.tableInlineForeignKey(new WriteForeignKey(null, column));
        buffer.append(",").newLine().append("  ").append(fkConstraint);
    }

    protected void writeInlineCompoundForeignKeys(DdlBuffer buffer, CreateTable createTable) {
        for (ForeignKey key : createTable.getForeignKey()) {
            String fkConstraint = this.platformDdl.tableInlineForeignKey(new WriteForeignKey(null, key));
            buffer.append(",").newLine().append("  ").append(fkConstraint);
        }
    }

    protected void writeAddForeignKeys(DdlWrite writer, CreateTable createTable) {
        for (Column column : createTable.getColumn()) {
            String references = column.getReferences();
            if (!this.hasValue(references)) continue;
            this.writeForeignKey(writer, createTable.getName(), column);
        }
        this.writeAddCompoundForeignKeys(writer, createTable);
    }

    protected void writeAddCompoundForeignKeys(DdlWrite writer, CreateTable createTable) {
        for (ForeignKey key : createTable.getForeignKey()) {
            this.writeForeignKey(writer, new WriteForeignKey(createTable.getName(), key));
        }
    }

    protected void writeForeignKey(DdlWrite writer, String tableName, Column column) {
        this.writeForeignKey(writer, new WriteForeignKey(tableName, column));
    }

    protected void writeForeignKey(DdlWrite writer, WriteForeignKey request) {
        DdlBuffer fkeyBuffer = writer.applyForeignKeys();
        String tableName = request.table();
        if (request.indexName() != null) {
            fkeyBuffer.appendStatement(this.platformDdl.createIndex(new WriteCreateIndex(request.indexName(), tableName, request.cols(), false)));
        }
        this.alterTableAddForeignKey(writer.getOptions(), fkeyBuffer, request);
        fkeyBuffer.end();
        writer.dropAllForeignKeys().appendStatement(this.platformDdl.alterTableDropForeignKey(tableName, request.fkName()));
        if (this.hasValue(request.indexName())) {
            writer.dropAllForeignKeys().appendStatement(this.platformDdl.dropIndex(request.indexName(), tableName));
        }
        writer.dropAllForeignKeys().end();
    }

    protected void alterTableAddForeignKey(DdlOptions options, DdlBuffer buffer, WriteForeignKey request) {
        buffer.appendStatement(this.platformDdl.alterTableAddForeignKey(options, request));
    }

    protected void appendColumns(String[] columns, DdlBuffer buffer) {
        buffer.append(" (");
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(this.platformDdl.quote(columns[i].trim()));
        }
        buffer.append(")");
    }

    protected void dropTable(DdlBuffer buffer, String tableName) {
        buffer.appendStatement(this.platformDdl.dropTable(tableName));
    }

    protected void dropSequence(DdlBuffer buffer, String sequenceName) {
        buffer.appendStatement(this.platformDdl.dropSequence(sequenceName));
    }

    protected void writeCompoundUniqueConstraints(DdlBuffer apply, CreateTable createTable) {
        boolean inlineUniqueWhenNull = this.platformDdl.isInlineUniqueWhenNullable();
        for (UniqueConstraint uniqueConstraint : createTable.getUniqueConstraint()) {
            if (!this.platformInclude(uniqueConstraint.getPlatforms())) continue;
            if (inlineUniqueWhenNull) {
                String uqName = uniqueConstraint.getName();
                apply.append(",").newLine();
                apply.append("  constraint ").append(uqName).append(" unique");
                this.appendColumns(SplitColumns.split(uniqueConstraint.getColumnNames()), apply);
                continue;
            }
            this.externalCompoundUnique.add(uniqueConstraint);
        }
    }

    private boolean platformInclude(String platforms) {
        return PlatformMatch.matchPlatform((Platform)this.platformDdl.getPlatform().getPlatform(), (String)platforms);
    }

    protected void writeUniqueConstraints(DdlBuffer apply, CreateTable createTable) {
        boolean inlineUniqueWhenNullable = this.platformDdl.isInlineUniqueWhenNullable();
        List<Column> columns = new WriteUniqueConstraint(createTable.getColumn()).uniqueKeys();
        for (Column column : columns) {
            if (Boolean.TRUE.equals(column.isNotnull()) || inlineUniqueWhenNullable) {
                this.inlineUniqueConstraintSingle(apply, column);
                continue;
            }
            this.externalUnique.add(column);
        }
    }

    protected void inlineUniqueConstraintSingle(DdlBuffer buffer, Column column) {
        String uqName = column.getUnique();
        if (uqName == null) {
            uqName = column.getUniqueOneToOne();
        }
        buffer.append(",").newLine();
        buffer.append("  constraint ").append(uqName).append(" unique ");
        buffer.append("(");
        buffer.append(this.platformDdl.quote(column.getName()));
        buffer.append(")");
    }

    protected void writePrimaryKeyConstraint(DdlBuffer buffer, String pkName, String[] pkColumns) {
        buffer.append(",").newLine();
        buffer.append("  constraint ").append(pkName).append(" primary key");
        this.appendColumns(pkColumns, buffer);
    }

    protected String[] toColumnNames(List<Column> columns) {
        String[] cols = new String[columns.size()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = columns.get(i).getName();
        }
        return cols;
    }

    @Override
    public void generate(DdlWrite writer, CreateIndex index) {
        if (this.platformInclude(index.getPlatforms())) {
            writer.applyForeignKeys().appendStatement(this.platformDdl.createIndex(new WriteCreateIndex(index)));
            writer.dropAll().appendStatement(this.platformDdl.dropIndex(index.getIndexName(), index.getTableName(), Boolean.TRUE.equals(index.isConcurrent())));
        }
    }

    @Override
    public void generate(DdlWrite writer, DropIndex dropIndex) {
        if (this.platformInclude(dropIndex.getPlatforms())) {
            writer.applyDropDependencies().appendStatement(this.platformDdl.dropIndex(dropIndex.getIndexName(), dropIndex.getTableName(), Boolean.TRUE.equals(dropIndex.isConcurrent())));
        }
    }

    @Override
    public void generate(DdlWrite writer, AddUniqueConstraint constraint) {
        if (this.platformInclude(constraint.getPlatforms())) {
            if (DdlHelp.isDropConstraint(constraint.getColumnNames())) {
                writer.applyDropDependencies().appendStatement(this.platformDdl.alterTableDropUniqueConstraint(constraint.getTableName(), constraint.getConstraintName()));
            } else {
                String[] cols = SplitColumns.split(constraint.getColumnNames());
                String[] nullableColumns = SplitColumns.split(constraint.getNullableColumns());
                writer.applyPostAlter().appendStatement(this.platformDdl.alterTableAddUniqueConstraint(constraint.getTableName(), constraint.getConstraintName(), cols, nullableColumns));
            }
        }
    }

    @Override
    public void generate(DdlWrite writer, AlterForeignKey alterForeignKey) {
        if (DdlHelp.isDropForeignKey(alterForeignKey.getColumnNames())) {
            writer.applyDropDependencies().appendStatement(this.platformDdl.alterTableDropForeignKey(alterForeignKey.getTableName(), alterForeignKey.getName()));
        } else {
            writer.applyForeignKeys().appendStatement(this.platformDdl.alterTableAddForeignKey(writer.getOptions(), new WriteForeignKey(alterForeignKey)));
        }
    }

    @Override
    public void generate(DdlWrite writer, AddHistoryTable addHistoryTable) {
        this.platformDdl.addHistoryTable(writer, addHistoryTable);
    }

    @Override
    public void generate(DdlWrite writer, DropHistoryTable dropHistoryTable) {
        this.platformDdl.dropHistoryTable(writer, dropHistoryTable);
    }

    @Override
    public void generateProlog(DdlWrite writer) {
        this.platformDdl.generateProlog(writer);
    }

    @Override
    public void generateEpilog(DdlWrite writer) {
        this.platformDdl.generateEpilog(writer);
    }

    @Override
    public void generate(DdlWrite writer, AddTableComment addTableComment) {
        if (this.hasValue(addTableComment.getComment())) {
            this.platformDdl.addTableComment(writer.applyPostAlter(), addTableComment.getName(), addTableComment.getComment());
        }
    }

    @Override
    public void generate(DdlWrite writer, AddColumn addColumn) {
        String tableName = addColumn.getTableName();
        List<Column> columns = addColumn.getColumn();
        for (Column column : columns) {
            this.alterTableAddColumn(writer, tableName, column, false, this.isTrue(addColumn.isWithHistory()));
        }
        if (this.isTrue(addColumn.isWithHistory())) {
            this.platformDdl.regenerateHistoryTriggers(writer, tableName);
            if (this.tableHistory != null) {
                String historyTable = this.tableHistory.historyTableName(tableName);
                for (Column column : columns) {
                    this.alterTableAddColumn(writer, historyTable, column, true, true);
                }
            }
        }
        for (Column column : columns) {
            if (!this.hasValue(column.getReferences())) continue;
            this.writeForeignKey(writer, tableName, column);
        }
    }

    @Override
    public void generate(DdlWrite writer, DropTable dropTable) {
        this.dropTable(writer.applyPostAlter(), dropTable.getName());
        if (this.hasValue(dropTable.getSequenceCol()) && this.platformDdl.getPlatform().getDbIdentity().isSupportsSequence()) {
            String sequenceName = dropTable.getSequenceName();
            if (!this.hasValue(sequenceName)) {
                sequenceName = this.namingConvention.getSequenceName(dropTable.getName(), dropTable.getSequenceCol());
            }
            this.dropSequence(writer.applyPostAlter(), sequenceName);
        }
    }

    @Override
    public void generate(DdlWrite writer, AlterTable alterTable) {
        String tableSpace = this.platformDdl.extract(alterTable.getTablespace());
        String indexSpace = this.platformDdl.extract(alterTable.getIndexTablespace());
        String lobSpace = this.platformDdl.extract(alterTable.getLobTablespace());
        if (this.hasValue(tableSpace) || this.hasValue(indexSpace) || this.hasValue(lobSpace)) {
            writer.apply().appendStatement(this.platformDdl.alterTableTablespace(alterTable.getName(), DdlHelp.toTablespace(tableSpace), DdlHelp.toTablespace(indexSpace), DdlHelp.toTablespace(lobSpace)));
        }
    }

    @Override
    public void generate(DdlWrite writer, DropColumn dropColumn) {
        String tableName = dropColumn.getTableName();
        this.alterTableDropColumn(writer, tableName, dropColumn.getColumnName());
        if (this.isTrue(dropColumn.isWithHistory())) {
            this.platformDdl.regenerateHistoryTriggers(writer, tableName);
            if (this.tableHistory != null) {
                this.alterTableDropColumn(writer, this.tableHistory.historyTableName(tableName), dropColumn.getColumnName());
            }
        }
    }

    @Override
    public void generate(DdlWrite writer, AlterColumn alterColumn) {
        boolean alterCheckConstraint;
        DdlMigrationHelp ddlHelp = new DdlMigrationHelp(alterColumn);
        ddlHelp.write(writer);
        if (alterColumn.isHistoryExclude() != null) {
            this.platformDdl.regenerateHistoryTriggers(writer, alterColumn.getTableName());
        }
        if (this.hasValue(alterColumn.getDropForeignKey())) {
            this.alterColumnDropForeignKey(writer, alterColumn);
        }
        if (this.hasValue(alterColumn.getReferences())) {
            this.alterColumnAddForeignKey(writer, alterColumn);
        }
        if (this.hasValue(alterColumn.getDropUnique())) {
            this.alterColumnDropUniqueConstraint(writer, alterColumn);
        }
        if (this.hasValue(alterColumn.getUnique())) {
            this.alterColumnAddUniqueConstraint(writer, alterColumn);
        }
        if (this.hasValue(alterColumn.getUniqueOneToOne())) {
            this.alterColumnAddUniqueOneToOneConstraint(writer, alterColumn);
        }
        if (this.hasValue(alterColumn.getComment())) {
            this.alterColumnComment(writer, alterColumn);
        }
        if (this.hasValue(alterColumn.getDropCheckConstraint())) {
            this.dropCheckConstraint(writer, alterColumn, alterColumn.getDropCheckConstraint());
        }
        if (alterCheckConstraint = this.hasValue(alterColumn.getCheckConstraint())) {
            this.dropCheckConstraint(writer, alterColumn, alterColumn.getCheckConstraintName());
        }
        if (this.typeChange(alterColumn) || this.hasValue(alterColumn.getDefaultValue()) || alterColumn.isNotnull() != null) {
            this.alterColumn(writer, alterColumn);
        }
        if (alterCheckConstraint) {
            this.addCheckConstraint(writer, alterColumn);
        }
    }

    private boolean typeChange(AlterColumn alterColumn) {
        if (!this.hasValue(alterColumn.getType())) {
            return false;
        }
        String currentType = this.platformDdl.convert(alterColumn.getCurrentType());
        String type = this.platformDdl.convert(alterColumn.getType());
        return !type.equals(currentType);
    }

    private void alterColumnComment(DdlWrite writer, AlterColumn alterColumn) {
        this.platformDdl.addColumnComment(writer.applyPostAlter(), alterColumn.getTableName(), alterColumn.getColumnName(), alterColumn.getComment());
    }

    protected void alterColumn(DdlWrite writer, AlterColumn alter) {
        this.platformDdl.alterColumn(writer, alter);
        if (this.isTrue(alter.isWithHistory())) {
            boolean isNull = Boolean.FALSE.equals(alter.isNotnull());
            boolean applyToHistory = alter.getType() != null || isNull;
            boolean syncExact = this.platformDdl.getPlatform().isPlatform(Platform.DB2);
            if (syncExact && alter.isNotnull() != null) {
                applyToHistory = true;
            }
            if (applyToHistory) {
                this.platformDdl.regenerateHistoryTriggers(writer, alter.getTableName());
                if (this.tableHistory != null) {
                    AlterColumn alterHistoryColumn = new AlterColumn();
                    alterHistoryColumn.setTableName(this.tableHistory.historyTableName(alter.getTableName()));
                    alterHistoryColumn.setColumnName(alter.getColumnName());
                    alterHistoryColumn.setCurrentType(alter.getCurrentType());
                    alterHistoryColumn.setType(alter.getType());
                    if (syncExact) {
                        alterHistoryColumn.setCurrentNotnull(alter.isCurrentNotnull());
                        alterHistoryColumn.setNotnull(alter.isNotnull());
                    } else if (isNull) {
                        alterHistoryColumn.setCurrentNotnull(Boolean.TRUE);
                        alterHistoryColumn.setNotnull(Boolean.FALSE);
                    } else {
                        alterHistoryColumn.setCurrentNotnull(Boolean.FALSE);
                    }
                    this.platformDdl.alterColumn(writer, alterHistoryColumn);
                }
            }
        }
    }

    protected void dropCheckConstraint(DdlWrite writer, AlterColumn alter, String constraintName) {
        writer.applyDropDependencies().appendStatement(this.platformDdl.alterTableDropConstraint(alter.getTableName(), constraintName));
    }

    protected void addCheckConstraint(DdlWrite writer, AlterColumn alter) {
        writer.applyPostAlter().appendStatement(this.platformDdl.alterTableAddCheckConstraint(alter.getTableName(), alter.getCheckConstraintName(), alter.getCheckConstraint()));
    }

    protected void alterColumnAddForeignKey(DdlWrite writer, AlterColumn alterColumn) {
        this.alterTableAddForeignKey(writer.getOptions(), writer.applyForeignKeys(), new WriteForeignKey(alterColumn));
    }

    protected void alterColumnDropForeignKey(DdlWrite writer, AlterColumn alter) {
        writer.applyDropDependencies().appendStatement(this.platformDdl.alterTableDropForeignKey(alter.getTableName(), alter.getDropForeignKey()));
    }

    protected void alterColumnDropUniqueConstraint(DdlWrite writer, AlterColumn alter) {
        writer.applyDropDependencies().appendStatement(this.platformDdl.alterTableDropUniqueConstraint(alter.getTableName(), alter.getDropUnique()));
    }

    protected void alterColumnAddUniqueOneToOneConstraint(DdlWrite writer, AlterColumn alter) {
        this.addUniqueConstraint(writer, alter, alter.getUniqueOneToOne());
    }

    protected void alterColumnAddUniqueConstraint(DdlWrite writer, AlterColumn alter) {
        this.addUniqueConstraint(writer, alter, alter.getUnique());
    }

    protected void addUniqueConstraint(DdlWrite writer, AlterColumn alter, String uqName) {
        String[] cols = new String[]{alter.getColumnName()};
        boolean notNull = alter.isNotnull() != null ? alter.isNotnull().booleanValue() : Boolean.TRUE.equals(alter.isNotnull());
        writer.applyPostAlter().appendStatement(this.platformDdl.alterTableAddUniqueConstraint(alter.getTableName(), uqName, cols, notNull ? null : cols));
        writer.dropAllForeignKeys().appendStatement(this.platformDdl.dropIndex(uqName, alter.getTableName()));
    }

    protected void alterTableDropColumn(DdlWrite writer, String tableName, String columnName) {
        this.platformDdl.alterTableDropColumn(writer, tableName, columnName);
    }

    protected void alterTableAddColumn(DdlWrite writer, String tableName, Column column, boolean onHistoryTable, boolean withHistory) {
        DdlMigrationHelp help = new DdlMigrationHelp(tableName, column, withHistory);
        if (!onHistoryTable) {
            help.write(writer);
        }
        this.platformDdl.alterTableAddColumn(writer, tableName, column, onHistoryTable, help.getDefaultValue());
        String comment = column.getComment();
        if (comment != null && !comment.isEmpty()) {
            this.platformDdl.addColumnComment(writer.applyPostAlter(), tableName, column.getName(), comment);
        }
    }

    protected boolean isFalse(Boolean value) {
        return value != null && value == false;
    }

    protected boolean hasValue(String value) {
        return value != null && !value.trim().isEmpty();
    }

    protected boolean isTrue(Boolean value) {
        return Boolean.TRUE.equals(value);
    }

    private class DdlMigrationHelp {
        private final List<String> before;
        private final List<String> after;
        private final String tableName;
        private final String columnName;
        private final String defaultValue;
        private final boolean withHistory;

        DdlMigrationHelp(String tableName, Column column, boolean withHistory) {
            this.tableName = tableName;
            this.columnName = column.getName();
            this.defaultValue = BaseTableDdl.this.platformDdl.convertDefaultValue(column.getDefaultValue());
            boolean alterNotNull = Boolean.TRUE.equals(column.isNotnull());
            if (column.getBefore().isEmpty() && alterNotNull && this.defaultValue == null) {
                this.handleStrictError(tableName, this.columnName);
            }
            this.before = this.getScriptsForPlatform(column.getBefore());
            this.after = this.getScriptsForPlatform(column.getAfter());
            this.withHistory = withHistory;
        }

        DdlMigrationHelp(AlterColumn alter) {
            this.tableName = alter.getTableName();
            this.columnName = alter.getColumnName();
            String tmp = alter.getDefaultValue() != null ? alter.getDefaultValue() : alter.getCurrentDefaultValue();
            this.defaultValue = BaseTableDdl.this.platformDdl.convertDefaultValue(tmp);
            boolean alterNotNull = Boolean.TRUE.equals(alter.isNotnull());
            this.withHistory = BaseTableDdl.this.isTrue(alter.isWithHistory());
            if (alter.getBefore().isEmpty() && alterNotNull) {
                if (this.defaultValue == null) {
                    this.handleStrictError(this.tableName, this.columnName);
                }
                this.before = Collections.singletonList(BaseTableDdl.this.platformDdl.getUpdateNullWithDefault());
            } else {
                this.before = this.getScriptsForPlatform(alter.getBefore());
            }
            this.after = this.getScriptsForPlatform(alter.getAfter());
        }

        void write(DdlWrite writer) {
            if (!this.before.isEmpty()) {
                writer.apply().end();
                if (this.withHistory) {
                    writer.apply().append("-- NOTE: table has @History - special migration may be necessary").newLine();
                }
                for (String ddlScript : this.before) {
                    writer.apply().appendStatement(this.translate(ddlScript, this.tableName, this.columnName, this.defaultValue));
                }
            }
            if (!this.after.isEmpty()) {
                writer.applyPostAlter().append("-- NOTE: table has @History - special migration may be necessary").newLine();
                for (String ddlScript : this.after) {
                    writer.applyPostAlter().appendStatement(this.translate(ddlScript, this.tableName, this.columnName, this.defaultValue));
                }
                writer.applyPostAlter().end();
            }
        }

        private List<String> getScriptsForPlatform(List<DdlScript> scripts) {
            Platform searchPlatform = BaseTableDdl.this.platformDdl.getPlatform().getPlatform();
            for (DdlScript script : scripts) {
                if (!PlatformMatch.matchPlatform((Platform)searchPlatform, (String)script.getPlatforms())) continue;
                return script.getDdl();
            }
            return Collections.emptyList();
        }

        private String translate(String ddl, String tableName, String columnName, String defaultValue) {
            String ret = StringHelper.replace((String)ddl, (String)"${table}", (String)tableName);
            ret = StringHelper.replace((String)ret, (String)"${column}", (String)columnName);
            return StringHelper.replace((String)ret, (String)"${default}", (String)defaultValue);
        }

        private void handleStrictError(String tableName, String columnName) {
            if (BaseTableDdl.this.strictMode) {
                String message = "DB Migration of non-null column with no default value specified for: " + tableName + "." + columnName + " Use @DbDefault to specify a default value or specify dbMigration.setStrictMode(false)";
                throw new IllegalArgumentException(message);
            }
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

