/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.config.DatabaseConfig;
import io.ebean.config.DbConstraintNaming;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlAlterTable;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformHistoryDdl;
import io.ebeaninternal.dbmigration.migration.AddHistoryTable;
import io.ebeaninternal.dbmigration.migration.AlterColumn;
import io.ebeaninternal.dbmigration.migration.DropHistoryTable;
import io.ebeaninternal.dbmigration.model.MTable;

public class SqlServerHistoryDdl
implements PlatformHistoryDdl {
    private String systemPeriodStart;
    private String systemPeriodEnd;
    private PlatformDdl platformDdl;
    protected DbConstraintNaming constraintNaming;
    protected String historySuffix;

    @Override
    public void configure(DatabaseConfig config, PlatformDdl platformDdl) {
        this.systemPeriodStart = config.getAsOfSysPeriod() + "From";
        this.systemPeriodEnd = config.getAsOfSysPeriod() + "To";
        this.platformDdl = platformDdl;
        this.constraintNaming = config.getConstraintNaming();
        this.historySuffix = config.getHistoryTableSuffix();
    }

    @Override
    public void createWithHistory(DdlWrite writer, MTable table) {
        String baseTable = table.getName();
        this.enableSystemVersioning(writer, baseTable);
    }

    private void enableSystemVersioning(DdlWrite writer, String baseTable) {
        DdlBuffer apply = writer.applyPostAlter();
        apply.append("alter table ").append(this.quote(baseTable)).newLine().append("    add ").append(this.systemPeriodStart).append(" datetime2 GENERATED ALWAYS AS ROW START NOT NULL DEFAULT SYSUTCDATETIME(),").newLine().append("        ").append(this.systemPeriodEnd).append("   datetime2 GENERATED ALWAYS AS ROW END   NOT NULL DEFAULT '9999-12-31T23:59:59.9999999',").newLine().append("period for system_time (").append(this.systemPeriodStart).append(", ").append(this.systemPeriodEnd).append(")").endOfStatement();
        apply.append("alter table ").append(baseTable).append(" set (system_versioning = on (history_table=").append(this.historyTableWithSchema(baseTable)).append("))").endOfStatement();
        DdlBuffer drop = writer.dropAll();
        drop.append("IF OBJECT_ID('").append(this.quote(baseTable)).append("', 'U') IS NOT NULL alter table ").append(this.quote(baseTable)).append(" set (system_versioning = off)").endOfStatement();
        drop.append("IF OBJECT_ID('").append(this.historyTableName(baseTable)).append("', 'U') IS NOT NULL drop table ").append(this.historyTableName(baseTable)).endOfStatement();
    }

    @Override
    public void dropHistoryTable(DdlWrite writer, DropHistoryTable dropHistoryTable) {
        String baseTable = dropHistoryTable.getBaseTable();
        AlterColumn alter = new AlterColumn();
        alter.setTableName(baseTable);
        alter.setDefaultValue("DROP DEFAULT");
        alter.setColumnName(this.systemPeriodStart);
        this.platformDdl.alterColumn(writer, alter);
        alter.setColumnName(this.systemPeriodEnd);
        this.platformDdl.alterColumn(writer, alter);
        DdlBuffer apply = writer.apply();
        apply.append("-- dropping history support for ").append(baseTable).endOfStatement();
        apply.append("alter table ").append(this.quote(baseTable)).append(" set (system_versioning = off)").endOfStatement();
        apply.append("alter table ").append(this.quote(baseTable)).append(" drop period for system_time").endOfStatement();
        apply.end();
        this.platformDdl.alterTableDropColumn(writer, baseTable, this.systemPeriodStart);
        this.platformDdl.alterTableDropColumn(writer, baseTable, this.systemPeriodEnd);
        writer.applyPostAlter().appendStatement(this.platformDdl.dropTable(this.historyTableName(baseTable)));
    }

    @Override
    public void addHistoryTable(DdlWrite writer, AddHistoryTable addHistoryTable) {
        String baseTable = addHistoryTable.getBaseTable();
        this.enableSystemVersioning(writer, baseTable);
    }

    @Override
    public void updateTriggers(DdlWrite writer, String tableName) {
        DdlAlterTable alter = this.platformDdl.alterTable(writer, tableName);
        writer.getTable(tableName);
        if (!alter.isHistoryHandled()) {
            DdlBuffer apply = writer.apply();
            apply.append("-- alter table ").append(this.quote(tableName)).append(" set (system_versioning = off (history_table=").append(this.historyTableWithSchema(tableName)).append("))").endOfStatement();
            apply.append("-- history migration goes here").newLine();
            apply.append("-- alter table ").append(this.quote(tableName)).append(" set (system_versioning = on (history_table=").append(this.historyTableWithSchema(tableName)).append("))").endOfStatement();
        }
        alter.setHistoryHandled();
    }

    protected String quote(String baseTable) {
        return this.platformDdl.quote(baseTable);
    }

    protected String normalise(String tableName) {
        return this.constraintNaming.normaliseTable(tableName);
    }

    protected String historyTableName(String baseTableName) {
        return this.normalise(baseTableName) + this.historySuffix;
    }

    protected String historyTableWithSchema(String baseTableName) {
        String historyTable = this.historyTableName(baseTableName);
        int lastPeriod = baseTableName.lastIndexOf(46);
        if (lastPeriod == -1) {
            return "dbo." + historyTable;
        }
        return baseTableName.substring(0, lastPeriod + 1) + historyTable;
    }
}

