/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.model.build;

import io.ebean.config.dbplatform.DbPlatformType;
import io.ebeaninternal.dbmigration.model.MColumn;
import io.ebeaninternal.dbmigration.model.MTable;
import io.ebeaninternal.dbmigration.model.build.ModelBuildContext;
import io.ebeaninternal.dbmigration.model.build.ModelBuildPropertyVisitor;
import io.ebeaninternal.dbmigration.model.visitor.BeanVisitor;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.InheritInfo;

public class ModelBuildBeanVisitor
implements BeanVisitor {
    private final ModelBuildContext ctx;

    public ModelBuildBeanVisitor(ModelBuildContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public ModelBuildPropertyVisitor visitBean(BeanDescriptor<?> descriptor) {
        if (!descriptor.isInheritanceRoot()) {
            return null;
        }
        MTable table = new MTable(descriptor);
        this.ctx.addTable(table);
        InheritInfo inheritInfo = descriptor.inheritInfo();
        if (inheritInfo != null && inheritInfo.isRoot()) {
            String discColumn = inheritInfo.getDiscriminatorColumn();
            String columnDefn = inheritInfo.getColumnDefn();
            if (columnDefn == null || columnDefn.isEmpty()) {
                DbPlatformType dbType = this.ctx.getDbTypeMap().get(inheritInfo.getDiscriminatorType());
                columnDefn = dbType.renderType(inheritInfo.getColumnLength(), 0);
            }
            table.addColumn(new MColumn(discColumn, columnDefn, true));
        }
        return new ModelBuildPropertyVisitor(this.ctx, table, descriptor);
    }
}

