/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.annotation.ConstraintMode;
import io.ebean.annotation.Platform;
import io.ebean.config.DatabaseConfig;
import io.ebean.config.DbConstraintNaming;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.DbDefaultValue;
import io.ebean.config.dbplatform.DbIdentity;
import io.ebean.config.dbplatform.IdType;
import io.ebean.util.StringHelper;
import io.ebeaninternal.dbmigration.ddlgeneration.BaseDdlHandler;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlAlterTable;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlHandler;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlOptions;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.BaseAlterTableWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlHelp;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlIdentity;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.NoHistorySupportDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformHistoryDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.WriteCreateIndex;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.WriteForeignKey;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.util.PlatformTypeConverter;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.util.VowelRemover;
import io.ebeaninternal.dbmigration.migration.AddHistoryTable;
import io.ebeaninternal.dbmigration.migration.AlterColumn;
import io.ebeaninternal.dbmigration.migration.Column;
import io.ebeaninternal.dbmigration.migration.CreateSchema;
import io.ebeaninternal.dbmigration.migration.DropHistoryTable;
import io.ebeaninternal.dbmigration.model.MTable;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlatformDdl {
    private static final Pattern CHECK_PATTERN = Pattern.compile("(.*?\\( *)([^ ]+)(.*)");
    protected final DatabasePlatform platform;
    protected PlatformHistoryDdl historyDdl = new NoHistorySupportDdl();
    private final PlatformTypeConverter typeConverter;
    private final DbIdentity dbIdentity;
    protected boolean inlineComments;
    protected String dropTableIfExists = "drop table if exists ";
    protected String dropTableCascade = "";
    protected String dropSequenceIfExists = "drop sequence if exists ";
    protected String foreignKeyOnDelete = "on delete";
    protected String foreignKeyOnUpdate = "on update";
    protected String identitySuffix = " auto_increment";
    protected String identityStartWith = "start with";
    protected String identityIncrementBy = "increment by";
    protected String identityCache = "cache";
    protected String sequenceStartWith = "start with";
    protected String sequenceIncrementBy = "increment by";
    protected String sequenceCache = "cache";
    protected String alterTableIfExists = "";
    protected String dropConstraintIfExists = "drop constraint if exists";
    protected String dropIndexIfExists = "drop index if exists ";
    protected String alterColumn = "alter column";
    protected String dropUniqueConstraint = "drop constraint";
    protected String addConstraint = "add constraint";
    protected String addColumn = "add column";
    protected String columnSetType = "";
    protected String columnSetDefault = "set default";
    protected String columnDropDefault = "drop default";
    protected String columnSetNotnull = "set not null";
    protected String columnSetNull = "set null";
    protected String columnNotNull = "not null";
    protected String updateNullWithDefault = "update ${table} set ${column} = ${default} where ${column} is null";
    protected boolean createSchemaSupport;
    protected String createSchema = "create schema if not exists";
    protected String createTable = "create table";
    protected String dropColumn = "drop column";
    protected String addForeignKeySkipCheck = "";
    protected String uniqueIndex = "unique";
    protected String indexConcurrent = "";
    protected String createIndexIfNotExists = "";
    protected boolean inlineUniqueWhenNullable = true;
    protected DbConstraintNaming naming;
    protected boolean inlineForeignKeys;
    protected boolean includeStorageEngine;
    protected final DbDefaultValue dbDefaultValue;
    protected String fallbackArrayType = "varchar(1000)";

    public PlatformDdl(DatabasePlatform platform) {
        this.platform = platform;
        this.dbIdentity = platform.getDbIdentity();
        this.dbDefaultValue = platform.getDbDefaultValue();
        this.typeConverter = new PlatformTypeConverter(platform.getDbTypeMap());
    }

    public void configure(DatabaseConfig config) {
        this.historyDdl.configure(config, this);
        this.naming = config.getConstraintNaming();
    }

    public DdlHandler createDdlHandler(DatabaseConfig config) {
        return new BaseDdlHandler(config, this);
    }

    public IdType useIdentityType(IdType modelIdentity) {
        if (modelIdentity == null) {
            return this.dbIdentity.getIdType();
        }
        return this.identityType(modelIdentity, this.dbIdentity.getIdType(), this.dbIdentity.isSupportsSequence(), this.dbIdentity.isSupportsIdentity());
    }

    private IdType identityType(IdType modelIdentity, IdType platformIdType, boolean supportsSequence, boolean supportsIdentity) {
        switch (modelIdentity) {
            case GENERATOR: {
                return IdType.GENERATOR;
            }
            case EXTERNAL: {
                return IdType.EXTERNAL;
            }
            case SEQUENCE: {
                return supportsSequence ? IdType.SEQUENCE : platformIdType;
            }
            case IDENTITY: {
                return supportsIdentity ? IdType.IDENTITY : platformIdType;
            }
        }
        return platformIdType;
    }

    public String asIdentityColumn(String columnDefn, DdlIdentity identity) {
        return columnDefn + this.identitySuffix;
    }

    protected String asIdentityStandardOptions(String columnDefn, DdlIdentity identity) {
        StringBuilder sb = new StringBuilder(columnDefn.length() + 60);
        sb.append(columnDefn).append(identity.optionGenerated());
        sb.append(identity.identityOptions(this.identityStartWith, this.identityIncrementBy, this.identityCache));
        return sb.toString();
    }

    public boolean isInlineComments() {
        return this.inlineComments;
    }

    public boolean isIncludeStorageEngine() {
        return this.includeStorageEngine;
    }

    public boolean isInlineForeignKeys() {
        return this.inlineForeignKeys;
    }

    public String setLockTimeout(int lockTimeoutSeconds) {
        return null;
    }

    public void writeTableColumns(DdlBuffer apply, List<Column> columns, DdlIdentity identity) {
        if ("true".equalsIgnoreCase(System.getProperty("ebean.ddl.sortColumns", "true"))) {
            columns = this.sortColumns(columns);
        }
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                apply.append(",");
            }
            apply.newLine();
            this.writeColumnDefinition(apply, columns.get(i), identity);
        }
        for (Column column : columns) {
            String checkConstraint = column.getCheckConstraint();
            if (!this.hasValue(checkConstraint) || !this.hasValue(checkConstraint = this.createCheckConstraint(this.maxConstraintName(column.getCheckConstraintName()), checkConstraint))) continue;
            apply.append(",").newLine();
            apply.append(checkConstraint);
        }
    }

    protected List<Column> sortColumns(List<Column> columns) {
        return columns;
    }

    protected void writeColumnDefinition(DdlBuffer buffer, Column column, DdlIdentity identity) {
        String defaultValue;
        String columnDefn = this.convert(column.getType());
        if (identity.useIdentity() && this.isTrue(column.isPrimaryKey())) {
            columnDefn = this.asIdentityColumn(columnDefn, identity);
        }
        buffer.append("  ");
        buffer.append(this.quote(column.getName()), 29);
        buffer.append(columnDefn);
        if (!Boolean.TRUE.equals(column.isPrimaryKey()) && (defaultValue = this.convertDefaultValue(column.getDefaultValue())) != null) {
            buffer.append(" default ").append(defaultValue);
        }
        if (this.isTrue(column.isNotnull()) || this.isTrue(column.isPrimaryKey())) {
            buffer.appendWithSpace(this.columnNotNull);
        }
    }

    public String createCheckConstraint(String ckName, String checkConstraint) {
        return "  constraint " + this.maxConstraintName(ckName) + " " + this.quoteCheckConstraint(checkConstraint);
    }

    public String convertDefaultValue(String dbDefault) {
        return this.dbDefaultValue.convert(dbDefault);
    }

    public String alterTableDropForeignKey(String tableName, String fkName) {
        return "alter table " + this.alterTableIfExists + this.quote(tableName) + " " + this.dropConstraintIfExists + " " + this.maxConstraintName(fkName);
    }

    public String convert(String type) {
        if (type == null) {
            return null;
        }
        if ((type = this.extract(type)).contains("[]")) {
            return this.convertArrayType(type);
        }
        return this.typeConverter.convert(type);
    }

    protected String extract(String type) {
        if (type == null) {
            return null;
        }
        String[] tmp = type.split(";", -1);
        if (tmp.length % 2 == 0) {
            throw new IllegalArgumentException("You need an odd number of arguments in '" + type + "'. See Issue #2559 for details");
        }
        for (int i = 0; i < tmp.length - 2; i += 2) {
            String[] platforms;
            for (String plat : platforms = tmp[i].split(",")) {
                if (!this.platform.isPlatform(Platform.valueOf((String)plat.toUpperCase(Locale.ENGLISH)))) continue;
                return tmp[i + 1];
            }
        }
        return tmp[tmp.length - 1];
    }

    protected String convertArrayType(String logicalArrayType) {
        if (logicalArrayType.endsWith("]")) {
            return this.fallbackArrayType;
        }
        int colonPos = logicalArrayType.lastIndexOf(93);
        return "varchar" + logicalArrayType.substring(colonPos + 1);
    }

    public void createWithHistory(DdlWrite writer, MTable table) {
        this.historyDdl.createWithHistory(writer, table);
    }

    public void dropHistoryTable(DdlWrite writer, DropHistoryTable dropHistoryTable) {
        this.historyDdl.dropHistoryTable(writer, dropHistoryTable);
    }

    public void addHistoryTable(DdlWrite writer, AddHistoryTable addHistoryTable) {
        this.historyDdl.addHistoryTable(writer, addHistoryTable);
    }

    public void regenerateHistoryTriggers(DdlWrite writer, String tableName) {
        this.historyDdl.updateTriggers(writer, tableName);
    }

    public String createSequence(String sequenceName, DdlIdentity identity) {
        StringBuilder sb = new StringBuilder("create sequence ");
        sb.append(this.quote(sequenceName));
        sb.append(identity.sequenceOptions(this.sequenceStartWith, this.sequenceIncrementBy, this.sequenceCache));
        sb.append(";");
        return sb.toString();
    }

    public String dropSequence(String sequenceName) {
        return this.dropSequenceIfExists + this.quote(sequenceName);
    }

    public String dropTable(String tableName) {
        return this.dropTableIfExists + this.quote(tableName) + this.dropTableCascade;
    }

    public String dropIndex(String indexName, String tableName) {
        return this.dropIndex(indexName, tableName, false);
    }

    public String dropIndex(String indexName, String tableName, boolean concurrent) {
        return this.dropIndexIfExists + this.maxConstraintName(indexName);
    }

    public String createIndex(WriteCreateIndex create) {
        if (create.useDefinition()) {
            return create.getDefinition();
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("create ");
        if (create.isUnique()) {
            buffer.append(this.uniqueIndex).append(" ");
        }
        buffer.append("index ");
        if (create.isConcurrent()) {
            buffer.append(this.indexConcurrent);
        }
        if (create.isNotExistsCheck()) {
            buffer.append(this.createIndexIfNotExists);
        }
        buffer.append(this.maxConstraintName(create.getIndexName())).append(" on ").append(this.quote(create.getTableName()));
        this.appendColumns(create.getColumns(), buffer);
        return buffer.toString();
    }

    public String tableInlineForeignKey(WriteForeignKey request) {
        StringBuilder buffer = new StringBuilder(90);
        buffer.append("foreign key");
        this.appendColumns(request.cols(), buffer);
        buffer.append(" references ").append(this.quote(request.refTable()));
        this.appendColumns(request.refCols(), buffer);
        this.appendForeignKeySuffix(request, buffer);
        return buffer.toString();
    }

    public String alterTableAddForeignKey(DdlOptions options, WriteForeignKey request) {
        StringBuilder buffer = new StringBuilder(90);
        buffer.append("alter table ").append(this.quote(request.table())).append(" add constraint ").append(this.maxConstraintName(request.fkName())).append(" foreign key");
        this.appendColumns(request.cols(), buffer);
        buffer.append(" references ").append(this.quote(request.refTable()));
        this.appendColumns(request.refCols(), buffer);
        this.appendForeignKeySuffix(request, buffer);
        if (options.isForeignKeySkipCheck()) {
            buffer.append(this.addForeignKeySkipCheck);
        }
        return buffer.toString();
    }

    protected void appendForeignKeySuffix(WriteForeignKey request, StringBuilder buffer) {
        this.appendForeignKeyOnDelete(buffer, this.withDefault(request.onDelete()));
        this.appendForeignKeyOnUpdate(buffer, this.withDefault(request.onUpdate()));
    }

    protected ConstraintMode withDefault(ConstraintMode mode) {
        return mode == null ? ConstraintMode.RESTRICT : mode;
    }

    protected void appendForeignKeyOnDelete(StringBuilder buffer, ConstraintMode mode) {
        this.appendForeignKeyMode(buffer, this.foreignKeyOnDelete, mode);
    }

    protected void appendForeignKeyOnUpdate(StringBuilder buffer, ConstraintMode mode) {
        this.appendForeignKeyMode(buffer, this.foreignKeyOnUpdate, mode);
    }

    protected void appendForeignKeyMode(StringBuilder buffer, String onMode, ConstraintMode mode) {
        buffer.append(" ").append(onMode).append(" ").append(this.translate(mode));
    }

    protected String translate(ConstraintMode mode) {
        switch (mode) {
            case SET_NULL: {
                return "set null";
            }
            case SET_DEFAULT: {
                return "set default";
            }
            case RESTRICT: {
                return "restrict";
            }
            case CASCADE: {
                return "cascade";
            }
        }
        throw new IllegalStateException("Unknown mode " + mode);
    }

    public String alterTableDropUniqueConstraint(String tableName, String uniqueConstraintName) {
        return "alter table " + this.quote(tableName) + " " + this.dropUniqueConstraint + " " + this.maxConstraintName(uniqueConstraintName);
    }

    public String alterTableDropConstraint(String tableName, String constraintName) {
        return "alter table " + this.quote(tableName) + " " + this.dropConstraintIfExists + " " + this.maxConstraintName(constraintName);
    }

    public String alterTableAddUniqueConstraint(String tableName, String uqName, String[] columns, String[] nullableColumns) {
        StringBuilder buffer = new StringBuilder(90);
        buffer.append("alter table ").append(this.quote(tableName)).append(" add constraint ").append(this.maxConstraintName(uqName)).append(" unique ");
        this.appendColumns(columns, buffer);
        return buffer.toString();
    }

    public void alterTableAddColumn(DdlWrite writer, String tableName, Column column, boolean onHistoryTable, String defaultValue) {
        String convertedType = this.convert(column.getType());
        DdlBuffer buffer = this.alterTable(writer, tableName).append(this.addColumn, column.getName());
        buffer.append(convertedType);
        if (!(defaultValue == null || onHistoryTable && this.isTrue(column.isHistoryExclude()))) {
            buffer.append(" default ");
            buffer.append(defaultValue);
        }
        if (!onHistoryTable) {
            if (this.isTrue(column.isNotnull())) {
                buffer.appendWithSpace(this.columnNotNull);
            }
            if (!StringHelper.isNull((String)column.getCheckConstraint())) {
                String ddl = this.alterTableAddCheckConstraint(tableName, column.getCheckConstraintName(), column.getCheckConstraint());
                writer.applyPostAlter().appendStatement(ddl);
            }
        }
    }

    public void alterTableAddColumn(DdlWrite writer, String tableName, String columnName, String columnType, String defaultValue) {
        String convertedType = this.convert(columnType);
        DdlBuffer buffer = this.alterTable(writer, tableName).append(this.addColumn, columnName);
        buffer.append(convertedType);
        if (defaultValue != null) {
            buffer.append(" default ");
            buffer.append(defaultValue);
        }
    }

    public void alterTableDropColumn(DdlWrite writer, String tableName, String columnName) {
        this.alterTable(writer, tableName).append(this.dropColumn, columnName);
    }

    public boolean isInlineUniqueWhenNullable() {
        return this.inlineUniqueWhenNullable;
    }

    protected void alterColumnType(DdlWrite writer, AlterColumn alter) {
        this.alterTable(writer, alter.getTableName()).append(this.alterColumn, alter.getColumnName()).append(this.columnSetType).append(this.convert(alter.getType()));
    }

    protected void alterColumnNotnull(DdlWrite writer, AlterColumn alter) {
        DdlBuffer buffer = this.alterTable(writer, alter.getTableName()).append(this.alterColumn, alter.getColumnName());
        if (Boolean.TRUE.equals(alter.isNotnull())) {
            buffer.append(this.columnSetNotnull);
        } else {
            buffer.append(this.columnSetNull);
        }
    }

    public String alterTableAddCheckConstraint(String tableName, String checkConstraintName, String checkConstraint) {
        return "alter table " + this.quote(tableName) + " " + this.addConstraint + " " + this.maxConstraintName(checkConstraintName) + " " + this.quoteCheckConstraint(checkConstraint);
    }

    protected void alterColumnDefault(DdlWrite writer, AlterColumn alter) {
        DdlBuffer buffer = this.alterTable(writer, alter.getTableName()).append(this.alterColumn, alter.getColumnName());
        if (DdlHelp.isDropDefault(alter.getDefaultValue())) {
            buffer.append(this.columnDropDefault);
        } else {
            buffer.append(this.columnSetDefault).appendWithSpace(this.convertDefaultValue(alter.getDefaultValue()));
        }
    }

    public void alterColumn(DdlWrite writer, AlterColumn alter) {
        if (this.hasValue(alter.getType())) {
            this.alterColumnType(writer, alter);
        }
        if (this.hasValue(alter.getDefaultValue())) {
            this.alterColumnDefault(writer, alter);
        }
        if (alter.isNotnull() != null) {
            this.alterColumnNotnull(writer, alter);
        }
    }

    protected DdlAlterTable alterTable(DdlWrite writer, String tableName) {
        return writer.applyAlterTable(tableName, k -> new BaseAlterTableWrite((String)k, this));
    }

    protected void appendColumns(String[] columns, StringBuilder buffer) {
        buffer.append(" (");
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(this.quote(columns[i].trim()));
        }
        buffer.append(")");
    }

    public DatabasePlatform getPlatform() {
        return this.platform;
    }

    public String getUpdateNullWithDefault() {
        return this.updateNullWithDefault;
    }

    protected boolean hasValue(String value) {
        return value != null && !value.trim().isEmpty();
    }

    protected boolean isTrue(Boolean value) {
        return Boolean.TRUE.equals(value);
    }

    public void inlineTableComment(DdlBuffer apply, String tableComment) {
    }

    public void tableStorageEngine(DdlBuffer apply, String storageEngine) {
    }

    public void addTableComment(DdlBuffer apply, String tableName, String tableComment) {
        if (DdlHelp.isDropComment(tableComment)) {
            tableComment = "";
        }
        apply.append(String.format("comment on table %s is '%s'", this.quote(tableName), tableComment)).endOfStatement();
    }

    public void addColumnComment(DdlBuffer apply, String table, String column, String comment) {
        if (DdlHelp.isDropComment(comment)) {
            comment = "";
        }
        apply.append(String.format("comment on column %s.%s is '%s'", this.quote(table), this.quote(column), comment)).endOfStatement();
    }

    public void generateProlog(DdlWrite writer) {
    }

    public void generateEpilog(DdlWrite writer) {
    }

    protected String maxConstraintName(String name) {
        if (name.length() > this.platform.getMaxConstraintNameLength()) {
            int hash = name.hashCode() & Integer.MAX_VALUE;
            if ((name = VowelRemover.trim(name, 4)).length() > this.platform.getMaxConstraintNameLength()) {
                return name.substring(0, this.platform.getMaxConstraintNameLength() - 7) + "_" + Integer.toString(hash, 36);
            }
        }
        return name;
    }

    public String getCreateTableCommandPrefix() {
        return this.createTable;
    }

    public void addTablePartition(DdlBuffer apply, String partitionMode, String partitionColumn) {
    }

    public void addDefaultTablePartition(DdlBuffer apply, String tableName) {
    }

    public void addTablespace(DdlBuffer apply, String tablespaceName, String indexTablespace, String lobTablespace) {
        throw new UnsupportedOperationException("Tablespaces are not supported for this platform");
    }

    public String alterTableTablespace(String tablename, String tableSpace, String indexSpace, String lobSpace) {
        if (tableSpace != null || indexSpace != null || lobSpace != null) {
            throw new UnsupportedOperationException("Tablespaces are not supported for this platform");
        }
        return null;
    }

    protected String quote(String dbName) {
        return this.platform.convertQuotedIdentifiers(dbName);
    }

    protected String quoteCheckConstraint(String checkConstraint) {
        Matcher matcher = CHECK_PATTERN.matcher(checkConstraint);
        if (matcher.matches()) {
            return matcher.replaceFirst("$1" + this.quote(matcher.group(2)) + "$3");
        }
        return checkConstraint;
    }

    public void createSchema(DdlWrite writer, CreateSchema request) {
        DdlBuffer apply = writer.apply();
        if (!this.createSchemaSupport) {
            apply.append("-- ");
        }
        apply.append(this.createSchema).append(" ").append(this.quote(request.getName())).endOfStatement();
    }

    public boolean addPartitionColumnToPrimaryKey() {
        return false;
    }
}

