/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.extraddl.model;

import io.avaje.applog.AppLog;
import io.ebean.annotation.Platform;
import io.ebeaninternal.api.PlatformMatch;
import io.ebeaninternal.extraddl.model.DdlScript;
import io.ebeaninternal.extraddl.model.ExtraDdl;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class ExtraDdlXmlReader {
    private static final System.Logger logger = AppLog.getLogger(ExtraDdlXmlReader.class);

    public static String buildExtra(Platform platform, boolean drops) {
        return ExtraDdlXmlReader.buildExtra(platform, drops, ExtraDdlXmlReader.read("/extra-ddl.xml"));
    }

    public static String buildPartitioning(Platform platform) {
        return ExtraDdlXmlReader.buildExtra(platform, false, ExtraDdlXmlReader.readBuiltinTablePartitioning());
    }

    private static String buildExtra(Platform platform, boolean drops, ExtraDdl read) {
        if (read == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(300);
        for (DdlScript script : read.getDdlScript()) {
            if (script.isDrop() != drops || !PlatformMatch.matchPlatform((Platform)platform, (String)script.getPlatforms())) continue;
            logger.log(System.Logger.Level.DEBUG, "include script {}", script.getName());
            String value = script.getValue();
            sb.append(value);
            if (value.lastIndexOf(59) == -1) {
                sb.append(";");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static ExtraDdl readBuiltin() {
        return ExtraDdlXmlReader.read("/io/ebeaninternal/dbmigration/builtin-extra-ddl.xml");
    }

    public static ExtraDdl readBuiltinTablePartitioning() {
        return ExtraDdlXmlReader.read("/io/ebeaninternal/dbmigration/builtin-extra-ddl-partitioning.xml");
    }

    public static ExtraDdl read() {
        return ExtraDdlXmlReader.read("/extra-ddl.xml");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ExtraDdl read(String resourcePath) {
        try (InputStream is = ExtraDdlXmlReader.class.getResourceAsStream(resourcePath);){
            if (is == null) {
                ExtraDdl extraDdl2 = null;
                return extraDdl2;
            }
            ExtraDdl extraDdl = ExtraDdlXmlReader.read(is);
            return extraDdl;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error on auto close of " + resourcePath, e);
        }
    }

    public static ExtraDdl read(InputStream is) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ExtraDdl.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return (ExtraDdl)unmarshaller.unmarshal(is);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

