/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration;

import io.ebean.DatabaseBuilder;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlHandler;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.TableDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.BaseTableDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.migration.AddColumn;
import io.ebeaninternal.dbmigration.migration.AddHistoryTable;
import io.ebeaninternal.dbmigration.migration.AddTableComment;
import io.ebeaninternal.dbmigration.migration.AddUniqueConstraint;
import io.ebeaninternal.dbmigration.migration.AlterColumn;
import io.ebeaninternal.dbmigration.migration.AlterForeignKey;
import io.ebeaninternal.dbmigration.migration.AlterTable;
import io.ebeaninternal.dbmigration.migration.ChangeSet;
import io.ebeaninternal.dbmigration.migration.CreateIndex;
import io.ebeaninternal.dbmigration.migration.CreateSchema;
import io.ebeaninternal.dbmigration.migration.CreateTable;
import io.ebeaninternal.dbmigration.migration.DropColumn;
import io.ebeaninternal.dbmigration.migration.DropHistoryTable;
import io.ebeaninternal.dbmigration.migration.DropIndex;
import io.ebeaninternal.dbmigration.migration.DropTable;
import java.util.List;

public class BaseDdlHandler
implements DdlHandler {
    protected final TableDdl tableDdl;

    public BaseDdlHandler(DatabaseBuilder.Settings config, PlatformDdl platformDdl) {
        this((DatabaseBuilder)config, platformDdl, new BaseTableDdl(config, platformDdl));
    }

    protected BaseDdlHandler(DatabaseBuilder config, PlatformDdl platformDdl, TableDdl tableDdl) {
        this.tableDdl = tableDdl;
    }

    @Override
    public void generate(DdlWrite writer, ChangeSet changeSet) {
        List<Object> changeSetChildren = changeSet.getChangeSetChildren();
        this.createSchemas(writer, changeSetChildren);
        this.createTables(writer, changeSetChildren);
        for (Object change : changeSetChildren) {
            if (change instanceof CreateTable || change instanceof CreateSchema) continue;
            if (change instanceof DropTable) {
                this.generate(writer, (DropTable)change);
                continue;
            }
            if (change instanceof AlterTable) {
                this.generate(writer, (AlterTable)change);
                continue;
            }
            if (change instanceof AddTableComment) {
                this.generate(writer, (AddTableComment)change);
                continue;
            }
            if (change instanceof CreateIndex) {
                this.generate(writer, (CreateIndex)change);
                continue;
            }
            if (change instanceof DropIndex) {
                this.generate(writer, (DropIndex)change);
                continue;
            }
            if (change instanceof AddColumn) {
                this.generate(writer, (AddColumn)change);
                continue;
            }
            if (change instanceof DropColumn) {
                this.generate(writer, (DropColumn)change);
                continue;
            }
            if (change instanceof AlterColumn) {
                this.generate(writer, (AlterColumn)change);
                continue;
            }
            if (change instanceof AddHistoryTable) {
                this.generate(writer, (AddHistoryTable)change);
                continue;
            }
            if (change instanceof DropHistoryTable) {
                this.generate(writer, (DropHistoryTable)change);
                continue;
            }
            if (change instanceof AddUniqueConstraint) {
                this.generate(writer, (AddUniqueConstraint)change);
                continue;
            }
            if (change instanceof AlterForeignKey) {
                this.generate(writer, (AlterForeignKey)change);
                continue;
            }
            throw new IllegalArgumentException("Unsupported change: " + String.valueOf(change));
        }
    }

    private void createTables(DdlWrite writer, List<Object> changeSetChildren) {
        for (Object change : changeSetChildren) {
            if (!(change instanceof CreateTable)) continue;
            this.generate(writer, (CreateTable)change);
        }
    }

    private void createSchemas(DdlWrite writer, List<Object> changeSetChildren) {
        boolean createdSchemas = false;
        for (Object change : changeSetChildren) {
            if (!(change instanceof CreateSchema)) continue;
            this.generate(writer, (CreateSchema)change);
            createdSchemas = true;
        }
        if (createdSchemas) {
            writer.apply().newLine();
        }
    }

    @Override
    public void generateProlog(DdlWrite writer) {
        this.tableDdl.generateProlog(writer);
    }

    @Override
    public void generateEpilog(DdlWrite writer) {
        this.tableDdl.generateEpilog(writer);
    }

    @Override
    public void generate(DdlWrite writer, CreateSchema createSchema) {
        this.tableDdl.generate(writer, createSchema);
    }

    @Override
    public void generate(DdlWrite writer, CreateTable createTable) {
        this.tableDdl.generate(writer, createTable);
    }

    @Override
    public void generate(DdlWrite writer, DropTable dropTable) {
        this.tableDdl.generate(writer, dropTable);
    }

    @Override
    public void generate(DdlWrite writer, AlterTable alterTable) {
        this.tableDdl.generate(writer, alterTable);
    }

    @Override
    public void generate(DdlWrite writer, AddTableComment addTableComment) {
        this.tableDdl.generate(writer, addTableComment);
    }

    @Override
    public void generate(DdlWrite writer, AddColumn addColumn) {
        this.tableDdl.generate(writer, addColumn);
    }

    @Override
    public void generate(DdlWrite writer, DropColumn dropColumn) {
        this.tableDdl.generate(writer, dropColumn);
    }

    @Override
    public void generate(DdlWrite writer, AlterColumn alterColumn) {
        this.tableDdl.generate(writer, alterColumn);
    }

    @Override
    public void generate(DdlWrite writer, AddHistoryTable addHistoryTable) {
        this.tableDdl.generate(writer, addHistoryTable);
    }

    @Override
    public void generate(DdlWrite writer, DropHistoryTable dropHistoryTable) {
        this.tableDdl.generate(writer, dropHistoryTable);
    }

    @Override
    public void generate(DdlWrite writer, CreateIndex createIndex) {
        this.tableDdl.generate(writer, createIndex);
    }

    @Override
    public void generate(DdlWrite writer, DropIndex dropIndex) {
        this.tableDdl.generate(writer, dropIndex);
    }

    @Override
    public void generate(DdlWrite writer, AddUniqueConstraint constraint) {
        this.tableDdl.generate(writer, constraint);
    }

    @Override
    public void generate(DdlWrite writer, AlterForeignKey alterForeignKey) {
        this.tableDdl.generate(writer, alterForeignKey);
    }
}

