/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DB2ColumnOptionsParser {
    private static final Pattern INLINE_LENGTH = Pattern.compile(".*( inline length \\d+).*", 2);
    private static final Pattern NOT_LOGGED = Pattern.compile(".*?(( not)? logged).*", 2);
    private static final Pattern NOT_COMPACT = Pattern.compile(".*?(( not)? compact).*", 2);
    private final String type;
    private final String inlineLength;
    private final boolean logged;
    private final boolean compact;
    private boolean extraOptions;

    DB2ColumnOptionsParser(String def) {
        Matcher m = INLINE_LENGTH.matcher(def);
        if (m.matches()) {
            def = def.replace(m.group(1), "");
            this.inlineLength = m.group(1).trim();
        } else {
            this.inlineLength = null;
        }
        m = NOT_LOGGED.matcher(def);
        if (m.matches()) {
            this.extraOptions = true;
            def = def.replace(m.group(1), "");
            this.logged = m.group(2) == null;
        } else {
            this.logged = true;
        }
        m = NOT_COMPACT.matcher(def);
        if (m.matches()) {
            this.extraOptions = true;
            def = def.replace(m.group(1), "");
            this.compact = m.group(2) == null;
        } else {
            this.compact = false;
        }
        this.type = def.trim();
    }

    public String getInlineLength() {
        return this.inlineLength;
    }

    public String getType() {
        return this.type;
    }

    public boolean isLogged() {
        return this.logged;
    }

    public boolean isCompact() {
        return this.compact;
    }

    public boolean hasExtraOptions() {
        return this.extraOptions;
    }
}

