/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.model;

import io.ebean.annotation.ConstraintMode;
import io.ebeaninternal.dbmigration.migration.AlterForeignKey;
import io.ebeaninternal.dbmigration.migration.ForeignKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MCompoundForeignKey {
    private String name;
    private final String referenceTable;
    private final List<String> columns = new ArrayList<String>();
    private final List<String> referenceColumns = new ArrayList<String>();
    private String indexName;
    private ConstraintMode fkeyOnDelete;
    private ConstraintMode fkeyOnUpdate;

    public MCompoundForeignKey(String name, String referenceTable, String indexName) {
        this.name = name;
        this.referenceTable = referenceTable;
        this.indexName = indexName;
    }

    public void addColumnPair(String dbCol, String refColumn) {
        this.columns.add(dbCol);
        this.referenceColumns.add(refColumn);
    }

    public ForeignKey createForeignKey() {
        ForeignKey fk = new ForeignKey();
        fk.setName(this.name);
        fk.setIndexName(this.indexName);
        fk.setColumnNames(this.toColumnNames(this.columns));
        fk.setRefColumnNames(this.toColumnNames(this.referenceColumns));
        fk.setRefTableName(this.referenceTable);
        fk.setOnDelete(this.fkeyModeOf(this.fkeyOnDelete));
        fk.setOnUpdate(this.fkeyModeOf(this.fkeyOnUpdate));
        return fk;
    }

    private String fkeyModeOf(ConstraintMode mode) {
        return mode == null ? null : mode.name();
    }

    public AlterForeignKey addForeignKey(String tableName) {
        AlterForeignKey fk = new AlterForeignKey();
        fk.setName(this.name);
        fk.setIndexName(this.indexName);
        fk.setColumnNames(this.toColumnNames(this.columns));
        fk.setRefColumnNames(this.toColumnNames(this.referenceColumns));
        fk.setRefTableName(this.referenceTable);
        fk.setTableName(tableName);
        return fk;
    }

    public AlterForeignKey dropForeignKey(String tableName) {
        AlterForeignKey fk = new AlterForeignKey();
        fk.setName(this.name);
        fk.setIndexName(this.indexName);
        fk.setColumnNames("DROP FOREIGN KEY");
        fk.setTableName(tableName);
        return fk;
    }

    public void addNameSuffix(int counter) {
        this.name = this.name + "_" + counter;
        this.indexName = this.indexName + "_" + counter;
    }

    public String getName() {
        return this.name;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    private String toColumnNames(List<String> columns) {
        StringBuilder sb = new StringBuilder(40);
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(columns.get(i));
        }
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.columns, this.indexName, this.name, this.referenceColumns, this.referenceTable);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MCompoundForeignKey)) {
            return false;
        }
        MCompoundForeignKey other = (MCompoundForeignKey)obj;
        return Objects.equals(this.columns, other.columns) && Objects.equals(this.indexName, other.indexName) && Objects.equals(this.name, other.name) && Objects.equals(this.referenceColumns, other.referenceColumns) && Objects.equals(this.referenceTable, other.referenceTable);
    }

    public void setForeignKeyModes(ConstraintMode onDelete, ConstraintMode onUpdate) {
        this.fkeyOnDelete = onDelete;
        this.fkeyOnUpdate = onUpdate;
    }
}

