/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.annotation.ConstraintMode;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlHelp;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlIdentity;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.SqlServerHistoryDdl;
import io.ebeaninternal.dbmigration.migration.AlterColumn;

public class SqlServerDdl
extends PlatformDdl {
    private static final String CONSTRAINT = "C";
    private static final String UNIQUE_CONSTRAINT = "UQ";
    private static final String USER_TABLE = "U";
    private static final String FOREIGN_KEY = "F";
    private static final String SEQUENCE_OBJECT = "SO";

    public SqlServerDdl(DatabasePlatform platform) {
        super(platform);
        this.identitySuffix = " identity(1,1)";
        this.alterTableIfExists = "";
        this.addColumn = "add";
        this.inlineUniqueWhenNullable = false;
        this.columnSetDefault = "add default";
        this.dropConstraintIfExists = "drop constraint";
        this.historyDdl = new SqlServerHistoryDdl();
    }

    @Override
    protected void appendForeignKeyMode(StringBuilder buffer, String onMode, ConstraintMode mode) {
        if (mode != ConstraintMode.RESTRICT) {
            super.appendForeignKeyMode(buffer, onMode, mode);
        }
    }

    @Override
    public String dropTable(String tableName) {
        return SqlServerDdl.ifObjectExists(tableName, USER_TABLE) + "drop table " + tableName;
    }

    @Override
    public String alterTableDropForeignKey(String tableName, String fkName) {
        int pos = tableName.lastIndexOf(46);
        Object objectId = this.maxConstraintName(fkName);
        if (pos != -1) {
            objectId = tableName.substring(0, pos + 1) + fkName;
        }
        return SqlServerDdl.ifObjectExists((String)objectId, FOREIGN_KEY) + super.alterTableDropForeignKey(tableName, fkName);
    }

    @Override
    public String dropSequence(String sequenceName) {
        return SqlServerDdl.ifObjectExists(sequenceName, SEQUENCE_OBJECT) + "drop sequence " + sequenceName;
    }

    @Override
    public String dropIndex(String indexName, String tableName, boolean concurrent) {
        return "IF EXISTS (SELECT name FROM sys.indexes WHERE object_id = OBJECT_ID('" + tableName + "','U') AND name = '" + this.maxConstraintName(indexName) + "') drop index " + this.maxConstraintName(indexName) + " ON " + tableName;
    }

    @Override
    public String alterTableAddUniqueConstraint(String tableName, String uqName, String[] columns, String[] nullableColumns) {
        if (nullableColumns == null || nullableColumns.length == 0) {
            return super.alterTableAddUniqueConstraint(tableName, uqName, columns, nullableColumns);
        }
        if (uqName == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("create unique nonclustered index ").append(uqName).append(" on ").append(tableName).append('(');
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(columns[i]);
        }
        sb.append(") where");
        String sep = " ";
        for (String column : nullableColumns) {
            sb.append(sep).append(column).append(" is not null");
            sep = " and ";
        }
        return sb.toString();
    }

    @Override
    public String alterTableDropConstraint(String tableName, String constraintName) {
        return SqlServerDdl.ifObjectExists(this.maxConstraintName(constraintName), CONSTRAINT) + super.alterTableDropConstraint(tableName, constraintName);
    }

    @Override
    public String alterTableDropUniqueConstraint(String tableName, String uniqueConstraintName) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.dropIndex(uniqueConstraintName, tableName)).append(";\n");
        sb.append(SqlServerDdl.ifObjectExists(this.maxConstraintName(uniqueConstraintName), UNIQUE_CONSTRAINT)).append(super.alterTableDropUniqueConstraint(tableName, uniqueConstraintName));
        return sb.toString();
    }

    @Override
    public String createSequence(String sequenceName, DdlIdentity identity) {
        int cache;
        StringBuilder sb = new StringBuilder(80);
        sb.append("create sequence ").append(sequenceName).append(" as bigint");
        int start = identity.getStart();
        if (start > 1) {
            sb.append(" start with ").append(start);
        } else {
            sb.append(" start with 1");
        }
        int increment = identity.getIncrement();
        if (increment > 1) {
            sb.append(" increment by ").append(increment);
        }
        if ((cache = identity.getCache()) > 1) {
            sb.append(" cache ").append(increment);
        }
        sb.append(';');
        return sb.toString();
    }

    @Override
    protected void alterColumnDefault(DdlWrite writer, AlterColumn alter) {
        String tableName = alter.getTableName();
        String columnName = alter.getColumnName();
        String defaultValue = alter.getDefaultValue();
        if (DdlHelp.isDropDefault(defaultValue)) {
            this.execUspDropDefaultConstraint(writer, tableName, columnName);
        } else {
            this.execUspDropDefaultConstraint(writer, tableName, columnName);
            this.setDefaultValue(writer, tableName, columnName, defaultValue);
        }
    }

    @Override
    public void alterColumn(DdlWrite writer, AlterColumn alter) {
        String tableName = alter.getTableName();
        String columnName = alter.getColumnName();
        if (alter.getType() == null && alter.isNotnull() == null) {
            if (this.hasValue(alter.getDefaultValue())) {
                this.alterColumnDefault(writer, alter);
            }
        } else {
            String defaultValue;
            String type = alter.getType() != null ? alter.getType() : alter.getCurrentType();
            type = this.convert(type);
            boolean notnull = alter.isNotnull() != null ? alter.isNotnull().booleanValue() : Boolean.TRUE.equals(alter.isCurrentNotnull());
            String string = defaultValue = alter.getDefaultValue() != null ? alter.getDefaultValue() : alter.getCurrentDefaultValue();
            if (this.hasValue(defaultValue)) {
                this.execUspDropDefaultConstraint(writer, tableName, columnName);
            }
            DdlBuffer buffer = this.alterTable(writer, tableName).append(this.alterColumn, columnName);
            buffer.append(type);
            if (notnull) {
                buffer.append(" not null");
            }
            if (this.hasValue(defaultValue) && !DdlHelp.isDropDefault(defaultValue)) {
                this.setDefaultValue(writer, tableName, columnName, defaultValue);
            }
        }
    }

    @Override
    public void addTableComment(DdlBuffer apply, String tableName, String tableComment) {
    }

    @Override
    public void addColumnComment(DdlBuffer apply, String table, String column, String comment) {
    }

    @Override
    public void alterTableDropColumn(DdlWrite writer, String tableName, String columnName) {
        this.alterTable(writer, tableName).raw("EXEC usp_ebean_drop_column ").append(tableName).append(", ").append(columnName);
    }

    @Override
    public void generateProlog(DdlWrite writer) {
        super.generateProlog(writer);
        this.generateTVPDefinitions(writer, "bigint");
        this.generateTVPDefinitions(writer, "float");
        this.generateTVPDefinitions(writer, "bit");
        this.generateTVPDefinitions(writer, "date");
        this.generateTVPDefinitions(writer, "time");
        this.generateTVPDefinitions(writer, "uniqueidentifier");
        this.generateTVPDefinitions(writer, "nvarchar(max)");
    }

    private void generateTVPDefinitions(DdlWrite writer, String definition) {
        int pos = definition.indexOf(40);
        String name = pos == -1 ? definition : definition.substring(0, pos);
        this.dropTVP(writer.dropAll(), name);
    }

    private void dropTVP(DdlBuffer ddl, String name) {
        ddl.append("if exists (select name  from sys.types where name = 'ebean_").append(name).append("_tvp') drop type ebean_").append(name).append("_tvp").endOfStatement();
    }

    private void createTVP(DdlBuffer ddl, String name, String definition) {
        ddl.append("if not exists (select name  from sys.types where name = 'ebean_").append(name).append("_tvp') create type ebean_").append(name).append("_tvp as table (c1 ").append(definition).append(")").endOfStatement();
    }

    public static String ifObjectExists(String object, String objectType) {
        return "IF OBJECT_ID('" + object + "', '" + objectType + "') IS NOT NULL ";
    }

    private void execUspDropDefaultConstraint(DdlWrite writer, String tableName, String columnName) {
        this.alterTable(writer, tableName).raw("EXEC usp_ebean_drop_default_constraint " + tableName + ", " + columnName);
    }

    private void setDefaultValue(DdlWrite writer, String tableName, String columnName, String defaultValue) {
        this.alterTable(writer, tableName).append("add default " + this.convertDefaultValue(defaultValue) + " for", columnName);
    }
}

