/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.DatabaseBuilder;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlAlterTable;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DbTableBasedHistoryDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformHistoryDdl;
import io.ebeaninternal.dbmigration.migration.AddHistoryTable;
import io.ebeaninternal.dbmigration.migration.DropHistoryTable;
import io.ebeaninternal.dbmigration.model.MTable;

public class Db2HistoryDdl
extends DbTableBasedHistoryDdl
implements PlatformHistoryDdl {
    private String systemPeriodStart;
    private String systemPeriodEnd;
    private String transactionId;

    @Override
    public void configure(DatabaseBuilder.Settings config, PlatformDdl platformDdl) {
        super.configure(config, platformDdl);
        this.systemPeriodStart = config.getAsOfSysPeriod() + "_start";
        this.systemPeriodEnd = config.getAsOfSysPeriod() + "_end";
        this.transactionId = config.getAsOfSysPeriod() + "_txn";
    }

    @Override
    public void createWithHistory(DdlWrite writer, MTable table) {
        String tableSpace;
        String tableName = table.getName();
        String historyTableName = this.historyTableName(tableName);
        this.addSysPeriodColumns(writer, tableName);
        DdlBuffer tableBuf = writer.applyPostAlter();
        tableBuf.append("create table ").append(historyTableName).append(" as (select * from ").append(tableName).append(") with no data");
        if (table.getTablespaceMeta() != null && (tableSpace = this.platformDdl.extract(table.getTablespaceMeta().getTablespaceName())) != null && !tableSpace.isEmpty()) {
            this.platformDdl.addTablespace(tableBuf, tableSpace, this.platformDdl.extract(table.getTablespaceMeta().getIndexTablespace()), this.platformDdl.extract(table.getTablespaceMeta().getLobTablespace()));
        }
        tableBuf.endOfStatement();
        this.enableSystemVersioning(writer.applyPostAlter(), tableName);
        this.platformDdl.alterTable(writer, tableName).setHistoryHandled();
        this.disableSystemVersioning(writer.dropAll(), tableName);
        writer.dropAll().append("drop table ").append(historyTableName).endOfStatement();
    }

    void addSysPeriodColumns(DdlWrite writer, String baseTable) {
        this.platformDdl.alterTableAddColumn(writer, baseTable, this.systemPeriodStart, "timestamp(12) not null generated always as row begin", null);
        this.platformDdl.alterTableAddColumn(writer, baseTable, this.systemPeriodEnd, "timestamp(12) not null generated always as row end", null);
        this.platformDdl.alterTableAddColumn(writer, baseTable, this.transactionId, "timestamp(12) generated always as transaction start id", null);
        this.platformDdl.alterTable(writer, baseTable).append("add period system_time", null).append("(").append(this.systemPeriodStart).append(",").append(this.systemPeriodEnd).append(")");
    }

    @Override
    public void dropHistoryTable(DdlWrite writer, DropHistoryTable dropHistoryTable) {
        this.dropHistoryTable(writer, dropHistoryTable.getBaseTable());
    }

    protected void dropHistoryTable(DdlWrite writer, String baseTable) {
        this.disableSystemVersioning(writer.apply(), baseTable);
        writer.apply().append("alter table ").append(baseTable).append(" drop period system_time").endOfStatement();
        this.platformDdl.alterTableDropColumn(writer, baseTable, this.systemPeriodStart);
        this.platformDdl.alterTableDropColumn(writer, baseTable, this.systemPeriodEnd);
        this.platformDdl.alterTableDropColumn(writer, baseTable, this.transactionId);
        writer.applyPostAlter().append("drop table ").append(this.historyTableName(baseTable)).endOfStatement();
    }

    @Override
    public void addHistoryTable(DdlWrite writer, AddHistoryTable addHistoryTable) {
        MTable table = writer.getTable(addHistoryTable.getBaseTable());
        if (table == null) {
            throw new IllegalStateException("MTable " + addHistoryTable.getBaseTable() + " not found in writer? (required for history DDL)");
        }
        this.createWithHistory(writer, table);
    }

    @Override
    public void updateTriggers(DdlWrite writer, String tableName) {
        DdlAlterTable alter = this.platformDdl.alterTable(writer, tableName);
        MTable table = writer.getTable(tableName);
        if (table.isWithHistory() && !alter.isHistoryHandled()) {
            this.disableSystemVersioning(writer.apply(), tableName);
            this.enableSystemVersioning(writer.applyPostAlter(), tableName);
            alter.setHistoryHandled();
        }
    }

    public void disableSystemVersioning(DdlBuffer apply, String tableName) {
        apply.append("alter table ").append(tableName).append(" drop versioning").endOfStatement();
    }

    public void enableSystemVersioning(DdlBuffer apply, String tableName) {
        apply.append("alter table ").append(tableName).append(" add versioning use history table ").append(this.historyTableName(tableName)).endOfStatement();
    }
}

