/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DbTriggerBasedHistoryDdl;
import java.util.List;

public class NuoDbHistoryDdl
extends DbTriggerBasedHistoryDdl {
    NuoDbHistoryDdl() {
        this.now = "now()";
        this.sysPeriodEndValue = "NEW.sys_period_start";
    }

    @Override
    protected void dropTriggers(DdlBuffer buffer, String baseTable) {
        buffer.append("drop trigger ").append(this.updateTriggerName(baseTable)).endOfStatement();
        buffer.append("drop trigger ").append(this.deleteTriggerName(baseTable)).endOfStatement();
    }

    @Override
    protected void createTriggers(DdlBuffer buffer, String baseTable, List<String> columnNames) {
        this.addBeforeUpdate(buffer, this.updateTriggerName(baseTable), baseTable, columnNames);
        this.addBeforeDelete(buffer, this.deleteTriggerName(baseTable), baseTable, columnNames);
    }

    private void addBeforeUpdate(DdlBuffer apply, String triggerName, String tableName, List<String> columnNames) {
        this.addTriggerStart(triggerName, tableName, apply, " before update for each row as ");
        apply.append("    NEW.sys_period_start = greatest(current_timestamp, date_add(OLD.sys_period_start, interval 1 microsecond))").endOfStatement();
        this.appendInsertIntoHistory(apply, tableName, columnNames);
        this.addEndTrigger(apply);
    }

    private void addBeforeDelete(DdlBuffer apply, String triggerName, String tableName, List<String> columnNames) {
        this.addTriggerStart(triggerName, tableName, apply, " before delete for each row as");
        this.appendInsertIntoHistory(apply, tableName, columnNames);
        this.addEndTrigger(apply);
    }

    private void addTriggerStart(String triggerName, String baseTable, DdlBuffer apply, String s) {
        apply.append("delimiter $$").newLine().append("create or replace trigger ").append(triggerName).append(" for ").append(baseTable).append(s).newLine();
    }

    private void addEndTrigger(DdlBuffer apply) {
        apply.append("end_trigger").endOfStatement().append("$$").newLine().newLine();
    }
}

