/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.model.build;

import io.ebeaninternal.dbmigration.model.MColumn;
import io.ebeaninternal.dbmigration.model.MTable;
import io.ebeaninternal.dbmigration.model.build.ModelBuildContext;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.TableJoin;
import io.ebeaninternal.server.deploy.TableJoinColumn;

class ModelBuildIntersectionTable {
    private final ModelBuildContext ctx;
    private final BeanPropertyAssocMany<?> manyProp;
    private final TableJoin intersectionTableJoin;
    private final TableJoin tableJoin;
    private MTable intersectionTable;

    ModelBuildIntersectionTable(ModelBuildContext ctx, BeanPropertyAssocMany<?> manyProp) {
        this.ctx = ctx;
        this.manyProp = manyProp;
        this.intersectionTableJoin = manyProp.intersectionTableJoin();
        this.tableJoin = manyProp.tableJoin();
    }

    public MTable build() {
        this.intersectionTable = this.createTable();
        MTable existingTable = this.ctx.addTable(this.intersectionTable);
        if (existingTable != null) {
            throw new IllegalStateException("Property " + this.manyProp.fullName() + " has duplicate ManyToMany intersection table " + this.intersectionTable.getName() + ". Please use @JoinTable to define unique table to use");
        }
        this.buildFkConstraints();
        return this.intersectionTable;
    }

    private void buildFkConstraints() {
        if (this.manyProp.hasForeignKeyConstraint()) {
            this.ctx.fkeyBuilder(this.intersectionTable).addForeignKey(this.manyProp.descriptor(), this.intersectionTableJoin, true).addForeignKey(this.manyProp.targetDescriptor(), this.tableJoin, false);
        }
        this.intersectionTable.checkDuplicateForeignKeys();
    }

    private MTable createTable() {
        TableJoinColumn[] otherColumns;
        TableJoinColumn[] columns;
        BeanDescriptor localDesc = this.manyProp.descriptor();
        BeanDescriptor targetDesc = this.manyProp.targetDescriptor();
        String tableName = this.intersectionTableJoin.getTable();
        MTable table = new MTable(tableName, localDesc);
        if (!this.manyProp.isExcludedFromHistory() && localDesc.isHistorySupport()) {
            table.setWithHistory(true);
        }
        table.setPkName(this.ctx.primaryKeyName(tableName));
        for (TableJoinColumn column : columns = this.intersectionTableJoin.columns()) {
            this.addColumn(table, localDesc, column.getForeignDbColumn(), column.getLocalDbColumn());
        }
        for (TableJoinColumn otherColumn : otherColumns = this.tableJoin.columns()) {
            this.addColumn(table, targetDesc, otherColumn.getLocalDbColumn(), otherColumn.getForeignDbColumn());
        }
        return table;
    }

    private void addColumn(MTable table, BeanDescriptor<?> desc, String column, String findPropColumn) {
        BeanProperty p = desc.idBinder().findBeanProperty(findPropColumn);
        if (p == null) {
            throw new RuntimeException("Could not find id property for " + findPropColumn);
        }
        MColumn col = new MColumn(column, this.ctx.getColumnDefn(p, true), true);
        col.setPrimaryKey(true);
        table.addColumn(col);
    }
}

