/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.migrationreader;

import io.ebeaninternal.dbmigration.migration.Migration;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MigrationXmlReader {
    private MigrationXmlReader() {
    }

    public static Migration read(String resourcePath) {
        Migration migration;
        block9: {
            InputStream is = MigrationXmlReader.class.getResourceAsStream(resourcePath);
            try {
                if (is == null) {
                    throw new IllegalArgumentException("No resource found for path [" + resourcePath + "]");
                }
                migration = MigrationXmlReader.read(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to auto close resource " + resourcePath, e);
                }
            }
            is.close();
        }
        return migration;
    }

    public static Migration read(File migrationFile) {
        Migration migration;
        FileInputStream is = new FileInputStream(migrationFile);
        try {
            migration = MigrationXmlReader.read(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        is.close();
        return migration;
    }

    public static Migration read(InputStream is) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Migration.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return (Migration)unmarshaller.unmarshal(is);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

