/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.model;

import io.ebean.annotation.ConstraintMode;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlHelp;
import io.ebeaninternal.dbmigration.migration.AlterColumn;
import io.ebeaninternal.dbmigration.migration.Column;
import io.ebeaninternal.dbmigration.migration.DdlScript;
import io.ebeaninternal.dbmigration.model.MTable;
import io.ebeaninternal.dbmigration.model.ModelDiff;
import io.ebeaninternal.server.deploy.DbMigrationInfo;
import java.util.List;
import java.util.Objects;

public class MColumn {
    private static final String LOCALDATETIME = "localdatetime";
    private static final String TIMESTAMP = "timestamp";
    private String name;
    private String type;
    private String checkConstraint;
    private String checkConstraintName;
    private String defaultValue;
    private String references;
    private String foreignKeyName;
    private String foreignKeyIndex;
    private ConstraintMode fkeyOnDelete;
    private ConstraintMode fkeyOnUpdate;
    private String comment;
    private boolean historyExclude;
    private boolean notnull;
    private boolean primaryKey;
    private boolean identity;
    private String unique;
    private String uniqueOneToOne;
    private AlterColumn alterColumn;
    private List<DbMigrationInfo> dbMigrationInfos;

    public MColumn(Column column) {
        this.name = column.getName();
        this.type = column.getType();
        this.checkConstraint = column.getCheckConstraint();
        this.checkConstraintName = column.getCheckConstraintName();
        this.defaultValue = column.getDefaultValue();
        this.comment = column.getComment();
        this.references = column.getReferences();
        this.foreignKeyName = column.getForeignKeyName();
        this.foreignKeyIndex = column.getForeignKeyIndex();
        this.fkeyOnDelete = this.fkeyMode(column.getForeignKeyOnDelete());
        this.fkeyOnUpdate = this.fkeyMode(column.getForeignKeyOnUpdate());
        this.notnull = Boolean.TRUE.equals(column.isNotnull());
        this.primaryKey = Boolean.TRUE.equals(column.isPrimaryKey());
        this.identity = Boolean.TRUE.equals(column.isIdentity());
        this.unique = column.getUnique();
        this.uniqueOneToOne = column.getUniqueOneToOne();
        this.historyExclude = Boolean.TRUE.equals(column.isHistoryExclude());
    }

    private ConstraintMode fkeyMode(String mode) {
        return mode == null ? null : ConstraintMode.valueOf((String)mode);
    }

    public MColumn(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public MColumn(String name, String type, boolean notnull) {
        this.name = name;
        this.type = type;
        this.notnull = notnull;
    }

    public MColumn copyForDraft() {
        MColumn copy = new MColumn(this.name, this.type);
        copy.checkConstraint = this.checkConstraint;
        copy.checkConstraintName = this.checkConstraintName;
        copy.defaultValue = this.defaultValue;
        copy.dbMigrationInfos = this.dbMigrationInfos;
        copy.references = this.references;
        copy.comment = this.comment;
        copy.foreignKeyName = this.foreignKeyName;
        copy.foreignKeyIndex = this.foreignKeyIndex;
        copy.fkeyOnUpdate = this.fkeyOnUpdate;
        copy.fkeyOnDelete = this.fkeyOnDelete;
        copy.historyExclude = this.historyExclude;
        copy.notnull = this.notnull;
        copy.primaryKey = this.primaryKey;
        copy.identity = this.identity;
        copy.unique = this.unique;
        copy.uniqueOneToOne = this.uniqueOneToOne;
        return copy;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public void setIdentity(boolean identity) {
        this.identity = identity;
    }

    public String getCheckConstraint() {
        return this.checkConstraint;
    }

    public void setCheckConstraint(String checkConstraint) {
        this.checkConstraint = checkConstraint;
    }

    public String getCheckConstraintName() {
        return this.checkConstraintName;
    }

    public void setCheckConstraintName(String checkConstraintName) {
        this.checkConstraintName = checkConstraintName;
    }

    public String getForeignKeyName() {
        return this.foreignKeyName;
    }

    public void setForeignKeyName(String foreignKeyName) {
        this.foreignKeyName = foreignKeyName;
    }

    public String getForeignKeyIndex() {
        return this.foreignKeyIndex;
    }

    public void setForeignKeyIndex(String foreignKeyIndex) {
        this.foreignKeyIndex = foreignKeyIndex;
    }

    public void setForeignKeyModes(ConstraintMode onDelete, ConstraintMode onUpdate) {
        this.fkeyOnDelete = onDelete;
        this.fkeyOnUpdate = onUpdate;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getReferences() {
        return this.references;
    }

    public void setReferences(String references) {
        this.references = references;
    }

    public boolean isNotnull() {
        return this.notnull;
    }

    public void setNotnull(boolean notnull) {
        this.notnull = notnull;
    }

    public boolean isHistoryExclude() {
        return this.historyExclude;
    }

    public void setHistoryExclude(boolean historyExclude) {
        this.historyExclude = historyExclude;
    }

    public void setUnique(String unique) {
        this.unique = unique;
    }

    public String getUnique() {
        return this.unique;
    }

    public void setUniqueOneToOne(String uniqueOneToOne) {
        this.uniqueOneToOne = uniqueOneToOne;
    }

    public String getUniqueOneToOne() {
        return this.uniqueOneToOne;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isIncludeInHistory() {
        return !this.historyExclude;
    }

    public void clearForeignKey() {
        this.references = null;
        this.foreignKeyName = null;
        this.fkeyOnDelete = null;
        this.fkeyOnUpdate = null;
    }

    public Column createColumn() {
        Column c = new Column();
        c.setName(this.name);
        c.setType(this.type);
        if (this.notnull) {
            c.setNotnull(true);
        }
        if (this.primaryKey) {
            c.setPrimaryKey(true);
        }
        if (this.identity) {
            c.setIdentity(true);
        }
        if (this.historyExclude) {
            c.setHistoryExclude(true);
        }
        c.setCheckConstraint(this.checkConstraint);
        c.setCheckConstraintName(this.checkConstraintName);
        c.setReferences(this.references);
        c.setForeignKeyName(this.foreignKeyName);
        c.setForeignKeyIndex(this.foreignKeyIndex);
        c.setForeignKeyOnDelete(this.fkeyModeOf(this.fkeyOnDelete));
        c.setForeignKeyOnUpdate(this.fkeyModeOf(this.fkeyOnUpdate));
        c.setDefaultValue(this.defaultValue);
        c.setComment(this.comment);
        c.setUnique(this.unique);
        c.setUniqueOneToOne(this.uniqueOneToOne);
        if (this.dbMigrationInfos != null) {
            for (DbMigrationInfo info : this.dbMigrationInfos) {
                DdlScript script;
                if (!info.getPreAdd().isEmpty()) {
                    script = new DdlScript();
                    script.getDdl().addAll(info.getPreAdd());
                    script.setPlatforms(info.joinPlatforms());
                    c.getBefore().add(script);
                }
                if (info.getPostAdd().isEmpty()) continue;
                script = new DdlScript();
                script.getDdl().addAll(info.getPostAdd());
                script.setPlatforms(info.joinPlatforms());
                c.getAfter().add(script);
            }
        }
        return c;
    }

    private String fkeyModeOf(ConstraintMode mode) {
        return mode == null ? null : mode.name();
    }

    protected static boolean different(String val1, String val2) {
        return !Objects.equals(val1, val2);
    }

    private boolean hasValue(String val) {
        return val != null && !val.isEmpty();
    }

    private boolean hasValue(Boolean val) {
        return val != null;
    }

    private AlterColumn getAlterColumn(String tableName, boolean tableWithHistory) {
        if (this.alterColumn == null) {
            this.alterColumn = new AlterColumn();
            this.alterColumn.setColumnName(this.name);
            this.alterColumn.setTableName(tableName);
            if (tableWithHistory) {
                this.alterColumn.setWithHistory(Boolean.TRUE);
            }
            if (this.dbMigrationInfos != null) {
                for (DbMigrationInfo info : this.dbMigrationInfos) {
                    DdlScript script;
                    if (!info.getPreAlter().isEmpty()) {
                        script = new DdlScript();
                        script.getDdl().addAll(info.getPreAlter());
                        script.setPlatforms(info.joinPlatforms());
                        this.alterColumn.getBefore().add(script);
                    }
                    if (info.getPostAlter().isEmpty()) continue;
                    script = new DdlScript();
                    script.getDdl().addAll(info.getPostAlter());
                    script.setPlatforms(info.joinPlatforms());
                    this.alterColumn.getAfter().add(script);
                }
            }
        }
        return this.alterColumn;
    }

    public void compare(ModelDiff modelDiff, MTable table, MColumn newColumn) {
        AlterColumn alter;
        this.dbMigrationInfos = newColumn.dbMigrationInfos;
        boolean tableWithHistory = table.isWithHistory();
        String tableName = table.getName();
        this.alterColumn = null;
        boolean changeBaseAttribute = false;
        if (this.historyExclude != newColumn.historyExclude) {
            this.getAlterColumn(tableName, tableWithHistory).setHistoryExclude(newColumn.historyExclude);
        }
        if (MColumn.different(this.type, newColumn.type) && !this.localDateTime(this.type, newColumn.type)) {
            changeBaseAttribute = true;
            this.getAlterColumn(tableName, tableWithHistory).setType(newColumn.type);
        }
        if (this.notnull != newColumn.notnull) {
            changeBaseAttribute = true;
            this.getAlterColumn(tableName, tableWithHistory).setNotnull(newColumn.notnull);
        }
        if (MColumn.different(this.defaultValue, newColumn.defaultValue)) {
            alter = this.getAlterColumn(tableName, tableWithHistory);
            if (newColumn.defaultValue == null) {
                alter.setDefaultValue("DROP DEFAULT");
            } else {
                alter.setDefaultValue(newColumn.defaultValue);
            }
        }
        if (MColumn.different(this.comment, newColumn.comment)) {
            alter = this.getAlterColumn(tableName, tableWithHistory);
            if (newColumn.comment == null) {
                alter.setComment("DROP COMMENT");
            } else {
                alter.setComment(newColumn.comment);
            }
        }
        if (MColumn.different(this.checkConstraint, newColumn.checkConstraint)) {
            alter = this.getAlterColumn(tableName, tableWithHistory);
            if (this.hasValue(this.checkConstraint) && !this.hasValue(newColumn.checkConstraint)) {
                alter.setDropCheckConstraint(this.checkConstraintName);
            }
            if (this.hasValue(newColumn.checkConstraint)) {
                alter.setCheckConstraintName(newColumn.checkConstraintName);
                alter.setCheckConstraint(newColumn.checkConstraint);
            }
        }
        if (MColumn.different(this.references, newColumn.references) || this.hasValue(newColumn.references) && this.fkeyOnDelete != newColumn.fkeyOnDelete || this.hasValue(newColumn.references) && this.fkeyOnUpdate != newColumn.fkeyOnUpdate) {
            alter = this.getAlterColumn(tableName, tableWithHistory);
            if (this.hasValue(this.foreignKeyName)) {
                alter.setDropForeignKey(this.foreignKeyName);
            }
            if (this.hasValue(this.foreignKeyIndex)) {
                alter.setDropForeignKeyIndex(this.foreignKeyIndex);
            }
            if (this.hasValue(newColumn.references)) {
                alter.setReferences(newColumn.references);
                alter.setForeignKeyName(newColumn.foreignKeyName);
                alter.setForeignKeyIndex(newColumn.foreignKeyIndex);
                if (newColumn.fkeyOnDelete != null) {
                    alter.setForeignKeyOnDelete(this.fkeyModeOf(newColumn.fkeyOnDelete));
                }
                if (newColumn.fkeyOnUpdate != null) {
                    alter.setForeignKeyOnUpdate(this.fkeyModeOf(newColumn.fkeyOnUpdate));
                }
            }
        }
        if (MColumn.different(this.unique, newColumn.unique)) {
            alter = this.getAlterColumn(tableName, tableWithHistory);
            if (this.hasValue(this.unique)) {
                alter.setDropUnique(this.unique);
            }
            if (this.hasValue(newColumn.unique)) {
                alter.setUnique(newColumn.unique);
            }
        }
        if (MColumn.different(this.uniqueOneToOne, newColumn.uniqueOneToOne)) {
            alter = this.getAlterColumn(tableName, tableWithHistory);
            if (this.hasValue(this.uniqueOneToOne)) {
                alter.setDropUnique(this.uniqueOneToOne);
            }
            if (this.hasValue(newColumn.uniqueOneToOne)) {
                alter.setUniqueOneToOne(newColumn.uniqueOneToOne);
            }
        }
        if (this.alterColumn != null) {
            modelDiff.addAlterColumn(this.alterColumn);
            if (changeBaseAttribute) {
                this.alterColumn.setCurrentType(this.type);
                this.alterColumn.setCurrentNotnull(this.notnull);
            }
        }
    }

    boolean localDateTime(String type, String newType) {
        return LOCALDATETIME.equalsIgnoreCase(newType) && TIMESTAMP.equalsIgnoreCase(type);
    }

    public void setDbMigrationInfos(List<DbMigrationInfo> dbMigrationInfos) {
        this.dbMigrationInfos = dbMigrationInfos;
    }

    public MColumn rename(String newName) {
        this.name = newName;
        return this;
    }

    public void apply(AlterColumn alterColumn) {
        if (this.hasValue(alterColumn.getDropCheckConstraint())) {
            this.checkConstraint = null;
        }
        if (this.hasValue(alterColumn.getDropForeignKey())) {
            this.foreignKeyName = null;
            this.references = null;
        }
        if (this.hasValue(alterColumn.getDropForeignKeyIndex())) {
            this.foreignKeyIndex = null;
        }
        if (this.hasValue(alterColumn.getDropUnique())) {
            this.unique = null;
            this.uniqueOneToOne = null;
        }
        if (this.hasValue(alterColumn.getType())) {
            this.type = alterColumn.getType();
        }
        if (this.hasValue(alterColumn.isNotnull())) {
            this.notnull = alterColumn.isNotnull();
        }
        if (this.hasValue(alterColumn.getDefaultValue())) {
            this.defaultValue = alterColumn.getDefaultValue();
            if (DdlHelp.isDropDefault(this.defaultValue)) {
                this.defaultValue = null;
            }
        }
        if (this.hasValue(alterColumn.getCheckConstraint())) {
            this.checkConstraint = alterColumn.getCheckConstraint();
        }
        if (this.hasValue(alterColumn.getCheckConstraintName())) {
            this.checkConstraintName = alterColumn.getCheckConstraintName();
        }
        if (this.hasValue(alterColumn.getUnique())) {
            this.unique = alterColumn.getUnique();
        }
        if (this.hasValue(alterColumn.getUniqueOneToOne())) {
            this.uniqueOneToOne = alterColumn.getUniqueOneToOne();
        }
        if (this.hasValue(alterColumn.getReferences())) {
            this.references = alterColumn.getReferences();
        }
        if (this.hasValue(alterColumn.getForeignKeyName())) {
            this.foreignKeyName = alterColumn.getForeignKeyName();
        }
        if (this.hasValue(alterColumn.getForeignKeyIndex())) {
            this.foreignKeyIndex = alterColumn.getForeignKeyIndex();
        }
        if (this.hasValue(alterColumn.getComment())) {
            this.comment = alterColumn.getComment();
            if (DdlHelp.isDropComment(this.comment)) {
                this.comment = null;
            }
        }
        if (this.hasValue(alterColumn.getForeignKeyOnDelete())) {
            this.fkeyOnDelete = this.fkeyMode(alterColumn.getForeignKeyOnDelete());
        }
        if (this.hasValue(alterColumn.getForeignKeyOnUpdate())) {
            this.fkeyOnUpdate = this.fkeyMode(alterColumn.getForeignKeyOnUpdate());
        }
        if (this.hasValue(alterColumn.isHistoryExclude())) {
            this.historyExclude = alterColumn.isHistoryExclude();
        }
    }
}

