/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.ddlrunner;

import io.avaje.applog.AppLog;
import io.ebean.ddlrunner.DdlDetect;
import io.ebean.ddlrunner.DdlParser;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public final class DdlRunner {
    static final System.Logger logger = AppLog.getLogger((String)"io.ebean.DDL");
    private final DdlParser parser;
    private final String scriptName;
    private final boolean useAutoCommit;

    public DdlRunner(boolean useAutoCommit, String scriptName) {
        this(useAutoCommit, scriptName, DdlDetect.NONE);
    }

    public DdlRunner(boolean useAutoCommit, String scriptName, String platformName) {
        this(useAutoCommit, scriptName, DdlDetect.forPlatform(platformName));
    }

    public DdlRunner(boolean useAutoCommit, String scriptName, DdlDetect ddlAutoCommit) {
        this.useAutoCommit = useAutoCommit;
        this.scriptName = scriptName;
        this.parser = new DdlParser(this.useAutoCommit ? DdlDetect.NONE : ddlAutoCommit);
    }

    public List<String> runAll(String content, Connection connection) throws SQLException {
        List<String> statements = this.parser.parse(new StringReader(content));
        this.runStatements(statements, connection);
        return this.parser.nonTransactional();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runStatements(List<String> statements, Connection connection) throws SQLException {
        boolean setAutoCommit;
        boolean bl = setAutoCommit = this.useAutoCommit && !connection.getAutoCommit();
        if (setAutoCommit) {
            connection.setAutoCommit(true);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Executing {0} - {1} statements, autoCommit:{2}", this.scriptName, statements.size(), this.useAutoCommit);
            int y = statements.size();
            for (int x = 0; x < y; ++x) {
                String xOfy = x + 1 + " of " + y;
                String ddl = statements.get(x);
                this.runStatement(xOfy, ddl, connection);
            }
        }
        finally {
            if (setAutoCommit) {
                connection.setAutoCommit(false);
            }
        }
    }

    private void runStatement(String oneOf, String sql, Connection c) throws SQLException {
        if ((sql = sql.trim()).endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        } else if (sql.endsWith("/")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        if (sql.isEmpty()) {
            logger.log(System.Logger.Level.DEBUG, "skip empty statement at {0}", oneOf);
            return;
        }
        if (logger.isLoggable(System.Logger.Level.DEBUG)) {
            logger.log(System.Logger.Level.DEBUG, "executing {0} {1}", oneOf, this.summary(sql));
        }
        try (Statement statement = c.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException e) {
            if (this.useAutoCommit) {
                logger.log(System.Logger.Level.DEBUG, " ... ignoring error executing {0} error: {1}", this.summary(sql), e.getMessage());
            }
            throw new SQLException("Error executing [" + sql + "] error[" + e.getMessage() + "]", e);
        }
    }

    private String summary(String s) {
        if (s.length() > 80) {
            return s.substring(0, 80).trim().replace('\n', ' ') + "...";
        }
        return s.replace('\n', ' ');
    }

    public int runNonTransactional(Connection connection) {
        List<String> nonTransactional = this.parser.nonTransactional();
        return !nonTransactional.isEmpty() ? this.runNonTransactional(connection, nonTransactional) : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runNonTransactional(Connection connection, List<String> nonTransactional) {
        int count = 0;
        try {
            logger.log(System.Logger.Level.DEBUG, "running {0} non-transactional migration statements", nonTransactional.size());
            connection.setAutoCommit(true);
            for (String sql : nonTransactional) {
                try {
                    PreparedStatement statement = connection.prepareStatement(sql);
                    try {
                        logger.log(System.Logger.Level.DEBUG, "executing - {0}", sql);
                        statement.execute();
                        ++count;
                    }
                    finally {
                        if (statement == null) continue;
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    logger.log(System.Logger.Level.ERROR, "Error running non-transaction migration: " + sql, (Throwable)e);
                    int n = count;
                    try {
                        connection.setAutoCommit(false);
                    }
                    catch (SQLException e2) {
                        logger.log(System.Logger.Level.ERROR, "Error resetting connection autoCommit to false", (Throwable)e2);
                    }
                    return n;
                }
            }
            int n = count;
            return n;
        }
        catch (SQLException e) {
            logger.log(System.Logger.Level.ERROR, "Error trying to run non-transaction migrations", (Throwable)e);
            int n = count;
            return n;
        }
        finally {
            try {
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                logger.log(System.Logger.Level.ERROR, "Error resetting connection autoCommit to false", (Throwable)e);
            }
        }
    }
}

