/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.model;

import io.ebean.config.DatabaseConfig;
import io.ebean.config.DbMigrationConfig;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlHandler;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.PlatformDdlBuilder;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.migration.ChangeSet;
import io.ebeaninternal.dbmigration.migration.ChangeSetType;
import io.ebeaninternal.dbmigration.migration.Migration;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformDdlWriter {
    private static final Logger logger = LoggerFactory.getLogger(PlatformDdlWriter.class);
    private final DatabaseConfig databaseConfig;
    private final DbMigrationConfig config;
    private final PlatformDdl platformDdl;
    private final int lockTimeoutSeconds;

    public PlatformDdlWriter(DatabasePlatform platform, DatabaseConfig dbConfig, DbMigrationConfig config, int lockTimeoutSeconds) {
        this.platformDdl = PlatformDdlBuilder.create(platform);
        this.databaseConfig = dbConfig;
        this.config = config;
        this.lockTimeoutSeconds = lockTimeoutSeconds;
    }

    public void processMigration(Migration dbMigration, DdlWrite write, File writePath, String fullVersion) throws IOException {
        String lockSql;
        DdlHandler handler = this.handler();
        handler.generateProlog(write);
        if (this.lockTimeoutSeconds > 0 && (lockSql = this.platformDdl.setLockTimeout(this.lockTimeoutSeconds)) != null) {
            write.apply().append(lockSql).endOfStatement().newLine();
        }
        List<ChangeSet> changeSets = dbMigration.getChangeSet();
        for (ChangeSet changeSet : changeSets) {
            if (!this.isApply(changeSet)) continue;
            handler.generate(write, changeSet);
        }
        handler.generateEpilog(write);
        this.writePlatformDdl(write, writePath, fullVersion);
    }

    private boolean isApply(ChangeSet changeSet) {
        return changeSet.getType() == ChangeSetType.APPLY && !changeSet.getChangeSetChildren().isEmpty();
    }

    protected void writePlatformDdl(DdlWrite write, File resourcePath, String fullVersion) throws IOException {
        if (!write.isApplyEmpty()) {
            try (FileWriter applyWriter = this.createWriter(resourcePath, fullVersion, this.config.getApplySuffix());){
                this.writeApplyDdl(applyWriter, write);
                applyWriter.flush();
            }
        }
    }

    protected FileWriter createWriter(File path, String fullVersion, String suffix) throws IOException {
        File applyFile = new File(path, fullVersion + suffix);
        return new FileWriter(applyFile);
    }

    protected void writeApplyDdl(Writer writer, DdlWrite write) throws IOException {
        String header = this.config.getDdlHeader();
        if (header != null) {
            writer.append(header).append('\n');
        }
        this.prependDropDependencies(writer, write.applyDropDependencies());
        writer.append("-- apply changes\n");
        writer.append(write.apply().getBuffer());
        writer.append(write.applyForeignKeys().getBuffer());
        writer.append(write.applyHistoryView().getBuffer());
        writer.append(write.applyHistoryTrigger().getBuffer());
    }

    private void prependDropDependencies(Writer writer, DdlBuffer buffer) throws IOException {
        if (!buffer.isEmpty()) {
            writer.append("-- drop dependencies\n");
            writer.append(buffer.getBuffer());
            writer.append("\n");
        }
    }

    protected DdlHandler handler() {
        return this.platformDdl.createDdlHandler(this.databaseConfig);
    }

    public File subPath(File path, String suffix) {
        File subPath = new File(path, suffix);
        if (!subPath.exists() && !subPath.mkdirs()) {
            logger.error("failed to create directories for " + subPath.getAbsolutePath());
        }
        return subPath;
    }
}

