/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.run;

import io.ebeaninternal.api.SpiContainerBootup;
import java.util.Arrays;
import java.util.List;
import org.avaje.docker.container.AutoStart;

public class Bootup
implements SpiContainerBootup {
    private static List<String> knownContainers = Arrays.asList("postgres", "mysql", "sqlserver", "oracle");

    public void bootup() {
        this.setDockerRunWith();
        AutoStart.run();
    }

    private void setDockerRunWith() {
        String runWith = System.getProperty("docker_run_with");
        if (runWith == null && this.isKnownDockerName(runWith = System.getProperty("db"))) {
            System.setProperty("docker_run_with", runWith);
        }
    }

    private boolean isKnownDockerName(String runWith) {
        return runWith != null && knownContainers.contains(runWith);
    }
}

