/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.hazelcast;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.topic.ITopic;
import io.ebean.BackgroundExecutor;
import io.ebean.DatabaseBuilder;
import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheConfig;
import io.ebean.cache.ServerCacheFactory;
import io.ebean.cache.ServerCacheNotification;
import io.ebean.cache.ServerCacheNotify;
import io.ebean.hazelcast.HzCache;
import io.ebean.hazelcast.HzServerCacheNotify;
import io.ebeaninternal.server.cache.DefaultServerCacheConfig;
import io.ebeaninternal.server.cache.DefaultServerQueryCache;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HzCacheFactory
implements ServerCacheFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)"io.ebean.cache.HzCacheFactory");
    private final ConcurrentHashMap<String, HzQueryCache> queryCaches;
    private final HazelcastInstance instance;
    private final ITopic<String> queryCacheInvalidation;
    private final ITopic<String> tableModNotify;
    private final BackgroundExecutor executor;
    private ServerCacheNotify listener;

    public HzCacheFactory(DatabaseBuilder config, BackgroundExecutor executor) {
        Object hazelcastInstance;
        this.executor = executor;
        this.queryCaches = new ConcurrentHashMap();
        if (System.getProperty("hazelcast.logging.type") == null) {
            System.setProperty("hazelcast.logging.type", "slf4j");
        }
        this.instance = (hazelcastInstance = config.settings().getServiceObject("hazelcast")) != null ? (HazelcastInstance)hazelcastInstance : this.createInstance(config);
        this.tableModNotify = this.instance.getReliableTopic("tableModNotify");
        this.tableModNotify.addMessageListener(message -> this.processTableNotify((String)message.getMessageObject()));
        this.queryCacheInvalidation = this.instance.getReliableTopic("queryCacheInvalidation");
        this.queryCacheInvalidation.addMessageListener(message -> this.processInvalidation((String)message.getMessageObject()));
    }

    private HazelcastInstance createInstance(DatabaseBuilder config) {
        Object configuration = config.settings().getServiceObject("hazelcastConfiguration");
        if (configuration != null) {
            if (configuration instanceof ClientConfig) {
                return HazelcastClient.newHazelcastClient((ClientConfig)((ClientConfig)configuration));
            }
            if (configuration instanceof Config) {
                return Hazelcast.newHazelcastInstance((Config)((Config)configuration));
            }
            throw new IllegalArgumentException("Invalid Hazelcast configuration type " + String.valueOf(configuration.getClass()));
        }
        if (this.isServerMode(config.settings().getProperties())) {
            return Hazelcast.newHazelcastInstance();
        }
        return HazelcastClient.newHazelcastClient();
    }

    private boolean isServerMode(Properties properties) {
        return properties != null && properties.getProperty("ebean.hazelcast.servermode", "").equals("true");
    }

    public ServerCacheNotify createCacheNotify(ServerCacheNotify listener) {
        this.listener = listener;
        return new HzServerCacheNotify(this.tableModNotify);
    }

    public ServerCache createCache(ServerCacheConfig config) {
        if (config.isQueryCache()) {
            return this.createQueryCache(config);
        }
        return this.createNormalCache(config);
    }

    private ServerCache createNormalCache(ServerCacheConfig config) {
        String fullName = config.getType().name() + "-" + config.getCacheKey();
        logger.debug("get cache [{}]", (Object)fullName);
        IMap map = this.instance.getMap(fullName);
        return config.tenantAware((ServerCache)new HzCache((IMap<Object, Object>)map));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerCache createQueryCache(ServerCacheConfig config) {
        HzCacheFactory hzCacheFactory = this;
        synchronized (hzCacheFactory) {
            HzQueryCache cache = this.queryCaches.get(config.getCacheKey());
            if (cache == null) {
                logger.debug("create query cache [{}]", (Object)config.getCacheKey());
                cache = new HzQueryCache(new DefaultServerCacheConfig(config));
                cache.periodicTrim(this.executor);
                this.queryCaches.put(config.getCacheKey(), cache);
            }
            return config.tenantAware((ServerCache)cache);
        }
    }

    private void sendInvalidation(String key) {
        this.queryCacheInvalidation.publish((Object)key);
    }

    private void processInvalidation(String cacheName) {
        HzQueryCache cache = this.queryCaches.get(cacheName);
        if (cache != null) {
            cache.invalidate();
        }
    }

    private void processTableNotify(String rawMessage) {
        if (logger.isDebugEnabled()) {
            logger.debug("processTableNotify {}", (Object)rawMessage);
        }
        String[] split = rawMessage.split(",");
        HashSet<String> tables = new HashSet<String>(Arrays.asList(split));
        this.listener.notify(new ServerCacheNotification(tables));
    }

    private class HzQueryCache
    extends DefaultServerQueryCache {
        HzQueryCache(DefaultServerCacheConfig cacheConfig) {
            super(cacheConfig);
        }

        public void clear() {
            super.clear();
            HzCacheFactory.this.sendInvalidation(this.name);
        }

        private void invalidate() {
            super.clear();
        }
    }
}

