/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.hazelcast;

import com.hazelcast.topic.ITopic;
import io.ebean.cache.ServerCacheNotification;
import io.ebean.cache.ServerCacheNotify;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HzServerCacheNotify
implements ServerCacheNotify {
    private static final Logger log = LoggerFactory.getLogger((String)"io.ebean.cache.TABLEMODS");
    private final ITopic<String> tableModNotify;

    HzServerCacheNotify(ITopic<String> tableModNotify) {
        this.tableModNotify = tableModNotify;
    }

    public void notify(ServerCacheNotification tableModifications) {
        Set dependentTables = tableModifications.getDependentTables();
        if (dependentTables != null && !dependentTables.isEmpty()) {
            StringBuilder msg = new StringBuilder(50);
            for (String table : dependentTables) {
                msg.append(table).append(",");
            }
            String formattedMsg = msg.toString();
            if (log.isDebugEnabled()) {
                log.debug("Publish TableMods - {}", (Object)formattedMsg);
            }
            this.tableModNotify.publish((Object)formattedMsg);
        }
    }
}

