/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.jackson.jsonnode;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.ebean.config.DatabaseConfig;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.core.type.PostgresHelper;
import io.ebean.core.type.ScalarType;
import io.ebean.core.type.ScalarTypeSet;
import io.ebean.core.type.ScalarTypeSetFactory;
import io.ebean.jackson.jsonnode.JsonNodeSet;
import io.ebean.jackson.jsonnode.ScalarTypeJsonNode;
import io.ebean.jackson.jsonnode.ScalarTypeJsonNodePostgres;

public class JsonNodeTypeFactory
implements ScalarTypeSetFactory {
    public ScalarTypeSet<?> createTypeSet(DatabaseConfig config, Object objectMapper) {
        if (objectMapper == null) {
            return null;
        }
        ObjectMapper mapper = (ObjectMapper)objectMapper;
        ScalarTypeJsonNode.Varchar varchar = new ScalarTypeJsonNode.Varchar(mapper);
        ScalarTypeJsonNode.Clob clob = new ScalarTypeJsonNode.Clob(mapper);
        ScalarTypeJsonNode.Blob blob = new ScalarTypeJsonNode.Blob(mapper);
        ScalarTypeJsonNode json = clob;
        ScalarTypeJsonNode jsonb = clob;
        if (PostgresHelper.isPostgresCompatible((DatabasePlatform)config.getDatabasePlatform())) {
            json = new ScalarTypeJsonNodePostgres.JSON(mapper);
            jsonb = new ScalarTypeJsonNodePostgres.JSONB(mapper);
        }
        return new JsonNodeSet((ScalarType<JsonNode>)varchar, (ScalarType<JsonNode>)clob, (ScalarType<JsonNode>)blob, (ScalarType<JsonNode>)jsonb, (ScalarType<JsonNode>)json);
    }
}

