/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.joda.time;

import io.ebean.config.JsonConfig;
import io.ebean.core.type.BasicTypeConverter;
import io.ebean.core.type.ScalarTypeBaseDateTime;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;
import org.joda.time.DateTime;

final class ScalarTypeJodaDateTime
extends ScalarTypeBaseDateTime<DateTime> {
    ScalarTypeJodaDateTime(JsonConfig.DateTime mode) {
        super(mode, DateTime.class, false, 93);
    }

    public long convertToMillis(DateTime value) {
        return value.getMillis();
    }

    protected String toJsonNanos(DateTime value) {
        return String.valueOf(value.toDateTime().getMillis());
    }

    protected String toJsonISO8601(DateTime value) {
        return value.toString();
    }

    public DateTime convertFromMillis(long systemTimeMillis) {
        return new DateTime(systemTimeMillis);
    }

    public DateTime convertFromTimestamp(Timestamp ts) {
        return new DateTime(ts.getTime());
    }

    public DateTime convertFromInstant(Instant ts) {
        return new DateTime(ts.toEpochMilli());
    }

    public Timestamp convertToTimestamp(DateTime t) {
        return new Timestamp(t.getMillis());
    }

    public Object toJdbcType(Object value) {
        if (value instanceof DateTime) {
            return new Timestamp(((DateTime)value).getMillis());
        }
        return BasicTypeConverter.toTimestamp((Object)value);
    }

    public DateTime toBeanType(Object value) {
        if (value instanceof Date) {
            return new DateTime(((Date)value).getTime());
        }
        return (DateTime)value;
    }
}

