/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.joda.time;

import io.ebean.config.JsonConfig;
import io.ebean.core.type.BasicTypeConverter;
import io.ebean.core.type.ScalarTypeBaseDateTime;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;
import org.joda.time.LocalDateTime;

final class ScalarTypeJodaLocalDateTime
extends ScalarTypeBaseDateTime<LocalDateTime> {
    ScalarTypeJodaLocalDateTime(JsonConfig.DateTime mode) {
        super(mode, LocalDateTime.class, false, 93);
    }

    protected String toJsonNanos(LocalDateTime value) {
        return String.valueOf(value.toDateTime().getMillis());
    }

    protected String toJsonISO8601(LocalDateTime value) {
        return value.toString();
    }

    protected LocalDateTime fromJsonISO8601(String value) {
        return LocalDateTime.parse((String)value);
    }

    public long convertToMillis(LocalDateTime value) {
        return value.toDateTime().getMillis();
    }

    public LocalDateTime convertFromMillis(long systemTimeMillis) {
        return new LocalDateTime(systemTimeMillis);
    }

    public LocalDateTime convertFromTimestamp(Timestamp ts) {
        return new LocalDateTime(ts.getTime());
    }

    public LocalDateTime convertFromInstant(Instant ts) {
        return new LocalDateTime(ts.toEpochMilli());
    }

    public Timestamp convertToTimestamp(LocalDateTime t) {
        return new Timestamp(t.toDateTime().getMillis());
    }

    public Object toJdbcType(Object value) {
        if (value instanceof LocalDateTime) {
            return new Timestamp(((LocalDateTime)value).toDateTime().getMillis());
        }
        return BasicTypeConverter.toTimestamp((Object)value);
    }

    public LocalDateTime toBeanType(Object value) {
        if (value instanceof Date) {
            return new LocalDateTime(((Date)value).getTime());
        }
        return (LocalDateTime)value;
    }
}

