/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.maven;

import io.ebean.enhance.Transformer;
import io.ebean.enhance.ant.OfflineFileTransform;
import io.ebean.enhance.ant.TransformationListener;
import io.ebean.enhance.common.EnhanceContext;
import io.ebean.enhance.common.SummaryInfo;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;

abstract class AbstractEnhance
extends AbstractMojo {
    @Parameter(property="project.compileClasspathElements", required=true, readonly=true)
    List<String> compileClasspathElements;
    @Parameter(name="transformArgs")
    String transformArgs = "debug=1";
    @Parameter(name="packages")
    String packages;

    AbstractEnhance() {
    }

    public abstract void execute() throws MojoExecutionException;

    void executeFor(String classSource) throws MojoExecutionException {
        ClassLoader loader = this.buildClassLoader(classSource);
        Transformer transformer = new Transformer(loader, this.transformArgs);
        EnhanceContext ctx = transformer.getEnhanceContext();
        final Log log = this.getLog();
        log.info((CharSequence)("classSource=" + classSource + "  transformArgs=" + this.nullToEmpty(this.transformArgs)));
        log.info((CharSequence)ctx.packagesSummary());
        ctx.collectSummary();
        OfflineFileTransform ft = new OfflineFileTransform(transformer, loader, classSource);
        ft.setListener(new TransformationListener(){

            public void logEvent(String msg) {
                log.info((CharSequence)msg);
            }

            public void logError(String msg) {
                log.error((CharSequence)msg);
            }
        });
        ft.process(this.packages);
        SummaryInfo summaryInfo = ctx.summaryInfo();
        log.info((CharSequence)("loaded resources: " + summaryInfo.loadedResources()));
        log.info((CharSequence)AbstractEnhance.trim(summaryInfo.entities()));
        log.info((CharSequence)AbstractEnhance.trim(summaryInfo.queryBeans()));
        log.info((CharSequence)AbstractEnhance.trim(summaryInfo.transactional()));
        log.info((CharSequence)AbstractEnhance.trim(summaryInfo.queryCallers()));
        if (ctx.isEnableEntityFieldAccess()) {
            log.info((CharSequence)AbstractEnhance.trim(summaryInfo.fieldAccess()));
        }
    }

    private static String trim(String val) {
        if (val.length() > 290) {
            return val.substring(0, 289) + " ...";
        }
        return val;
    }

    private String nullToEmpty(String val) {
        return val == null ? "" : val;
    }

    private ClassLoader buildClassLoader(String classSource) {
        URL[] urls = this.buildClassPath(classSource);
        return URLClassLoader.newInstance(urls, Thread.currentThread().getContextClassLoader());
    }

    private URL[] buildClassPath(String classSource) {
        try {
            ArrayList<URL> urls = new ArrayList<URL>(this.compileClasspathElements.size());
            Log log = this.getLog();
            for (String element : this.compileClasspathElements) {
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)("ClasspathElement: " + element));
                }
                urls.add(new File(element).toURI().toURL());
            }
            log.debug((CharSequence)("add source: " + classSource));
            urls.add(new File(classSource).toURI().toURL());
            return urls.toArray(new URL[0]);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

