/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration;

import io.ebean.migration.DbPlatformNames;
import io.ebean.migration.util.JdbcClose;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DbNameUtil
implements DbPlatformNames {
    private static final Logger log = LoggerFactory.getLogger(DbNameUtil.class);

    DbNameUtil() {
    }

    static String normalise(Connection connection) {
        try {
            String productName = connection.getMetaData().getDatabaseProductName().toLowerCase();
            if (productName.contains("postgres")) {
                return DbNameUtil.readPostgres(connection);
            }
            if (productName.contains("mysql")) {
                return "mysql";
            }
            if (productName.contains("oracle")) {
                return "oracle";
            }
            if (productName.contains("microsoft")) {
                return "sqlserver";
            }
            if (productName.contains("db2")) {
                return "db2";
            }
            if (productName.contains("h2")) {
                return "h2";
            }
            if (productName.contains("hsql")) {
                return "hsql";
            }
            if (productName.contains("sqlite")) {
                return "sqlite";
            }
            if (productName.contains("sql anywhere")) {
                return "sqlanywhere";
            }
            return "";
        }
        catch (SQLException e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readPostgres(Connection connection) {
        ResultSet resultSet;
        PreparedStatement statement;
        block4: {
            String string;
            statement = null;
            resultSet = null;
            try {
                String productVersion;
                statement = connection.prepareStatement("SELECT version() AS \"version\"");
                resultSet = statement.executeQuery();
                if (!resultSet.next() || !(productVersion = resultSet.getString("version").toLowerCase()).contains("cockroach")) break block4;
                string = "cockroach";
            }
            catch (SQLException e) {
                try {
                    log.warn("Error running detection query on Postgres", (Throwable)e);
                }
                catch (Throwable throwable) {
                    JdbcClose.close(resultSet);
                    JdbcClose.close(statement);
                    throw throwable;
                }
                JdbcClose.close(resultSet);
                JdbcClose.close(statement);
            }
            JdbcClose.close(resultSet);
            JdbcClose.close(statement);
            return string;
        }
        JdbcClose.close(resultSet);
        JdbcClose.close(statement);
        return "postgres";
    }
}

